/*****************************************************************************************
APETag version history / supported formats

1.0 (1000) - Original APE tag spec.  Fully supported by this code.
2.0 (2000) - Refined APE tag spec (better streaming support, UTF encoding). Fully supported by this code.

Notes:
	- also supports reading of ID3v1.1 tags
	- all saving done in the APE Tag format using CURRENT_APE_TAG_VERSION
*****************************************************************************************/

/*****************************************************************************************
APETag layout

1) Header - APE_TAG_FOOTER (optional) (32 bytes)
2) Fields (array):
		Value Size (4 bytes)
		Flags (4 bytes)
		Field Name (? ANSI bytes -- requires NULL terminator -- in range of 0x20 (space) to 0x7E (tilde))
		Value ([Value Size] bytes)
3) Footer - APE_TAG_FOOTER (32 bytes)	
*****************************************************************************************/

/*****************************************************************************************
Notes

-When saving images, store the filename (no directory -- i.e. Cover.jpg) in UTF-8 followed 
by a null terminator, followed by the image data.
*****************************************************************************************/

/*****************************************************************************************
The version of the APE tag
*****************************************************************************************/
#define CURRENT_APE_TAG_VERSION		2000

/*****************************************************************************************
"Standard" APE tag fields
*****************************************************************************************/
/*
#define APE_TAG_FIELD_TITLE				"Title"
#define APE_TAG_FIELD_ARTIST			"Artist"
#define APE_TAG_FIELD_ALBUM				"Album"
#define APE_TAG_FIELD_COMMENT			"Comment"
#define APE_TAG_FIELD_YEAR				"Year"
#define APE_TAG_FIELD_TRACK				"Track"
#define APE_TAG_FIELD_GENRE				"Genre"
#define APE_TAG_FIELD_COVER_ART_FRONT	"Cover Art (front)"
#define APE_TAG_FIELD_NOTES				"Notes"
#define APE_TAG_FIELD_LYRICS			"Lyrics"
#define APE_TAG_FIELD_COPYRIGHT			"Copyright"
#define APE_TAG_FIELD_BUY_URL			"Buy URL"
#define APE_TAG_FIELD_ARTIST_URL		"Artist URL"
#define APE_TAG_FIELD_PUBLISHER_URL		"Publisher URL"
#define APE_TAG_FIELD_FILE_URL			"File URL"
#define APE_TAG_FIELD_COPYRIGHT_URL		"Copyright URL"
#define APE_TAG_FIELD_MJ_METADATA		"Media Jukebox Metadata"
#define APE_TAG_FIELD_TOOL_NAME			"Tool Name"
#define APE_TAG_FIELD_TOOL_VERSION		"Tool Version"
#define APE_TAG_FIELD_PEAK_LEVEL		"Peak Level"
#define APE_TAG_FIELD_REPLAY_GAIN_RADIO	"Replay Gain (radio)"
#define APE_TAG_FIELD_COMPOSER			"Composer"
#define APE_TAG_FIELD_KEYWORDS			"Keywords"
*/

#define	APE_TAG_FIELD_TITLE				"Title"
#define	APE_TAG_FIELD_SUBTITLE			"Subtitle"
#define	APE_TAG_FIELD_ARTIST			"Artist"
#define	APE_TAG_FIELD_ALBUM				"Album"
#define	APE_TAG_FIELD_DEBUTALBUM		"Debut Album"
#define	APE_TAG_FIELD_PUBLISHER			"Publisher"
#define	APE_TAG_FIELD_CONDUCTOR			"Conductor"
#define	APE_TAG_FIELD_COMPOSER			"Composer"
#define	APE_TAG_FIELD_COMMENT			"Comment"
#define	APE_TAG_FIELD_YEAR				"Date"
#define	APE_TAG_FIELD_YEAR_				"Year"
#define	APE_TAG_FIELD_RECORDDATE		"Record Date"
#define	APE_TAG_FIELD_RECORDLOCATION	"Record Location"
#define	APE_TAG_FIELD_TRACK				"Tracknumber"
#define	APE_TAG_FIELD_TRACK_			"Track"
#define	APE_TAG_FIELD_GENRE				"Genre"
#define	APE_TAG_FIELD_COVER_ART_FRONT	"Cover Art (front)"
#define	APE_TAG_FIELD_NOTES				"Notes"
#define	APE_TAG_FIELD_LYRICS			"Lyrics"
#define	APE_TAG_FIELD_COPYRIGHT			"Copyright"
#define	APE_TAG_FIELD_PUBLICATIONRIGHT	"Publicationright"
#define APE_TAG_FIELD_FILE				"File"
#define APE_TAG_FIELD_MEDIA				"Media"
#define APE_TAG_FIELD_EANUPC			"EAN/UPC"
#define APE_TAG_FIELD_ISRC				"ISRC"
#define APE_TAG_FIELD_RELATED_URL		"Related"
#define APE_TAG_FIELD_ABSTRACT_URL		"Abstract"
#define APE_TAG_FIELD_LANGUAGE			"Language"
#define APE_TAG_FIELD_BIBLIOGRAPHY_URL	"Bibliography"
#define APE_TAG_FIELD_BUY_URL			"Buy URL"
#define APE_TAG_FIELD_ARTIST_URL		"Artist URL"
#define APE_TAG_FIELD_PUBLISHER_URL		"Publisher URL"
#define APE_TAG_FIELD_FILE_URL			"File URL"
#define APE_TAG_FIELD_COPYRIGHT_URL		"Copyright URL"
#define APE_TAG_FIELD_INDEX				"Index"
#define APE_TAG_FIELD_INTROPLAY			"Introplay"
#define APE_TAG_FIELD_MJ_METADATA		"Media Jukebox Metadata"
#define APE_TAG_FIELD_DUMMY				"Dummy"

#define APE_TAG_FIELD_CONTENT_GROUP		"ContentGroup"
#define APE_TAG_FIELD_BAND				"Band"
#define APE_TAG_FIELD_MIX_ARTIST		"MixArtist"
#define APE_TAG_FIELD_RECORDING_DATES	"RecordingDates"
#define APE_TAG_FIELD_TIME				"Time"
#define APE_TAG_FIELD_PART_IN_SET		"PartInSet"
#define APE_TAG_FIELD_LYRICIST			"Lyricist"
#define APE_TAG_FIELD_ORIGINAL_ALBUM	"OrigAlbum"
#define APE_TAG_FIELD_ORIGINAL_ARTIST	"OrigArtist"
#define APE_TAG_FIELD_ORIGINAL_YEAR		"OrigYear"
#define APE_TAG_FIELD_ORIGINAL_FILENAME	"OrigFilename"
#define APE_TAG_FIELD_ORIGINAL_LYRICIST	"OrigLyricist"
#define APE_TAG_FIELD_ENCODED_BY		"EncodedBy"
#define APE_TAG_FIELD_ENCODER_SETTINGS	"EncoderSettings"
#define APE_TAG_FIELD_BPM				"BPM"
#define APE_TAG_FIELD_INITIAL_KEY		"InitialKey"
#define APE_TAG_FIELD_PLAYLIST_DELAY	"PlaylistDelay"
#define APE_TAG_FIELD_FILE_TYPE			"FileType"
#define APE_TAG_FIELD_MEDIA_TYPE		"MediaType"
#define APE_TAG_FIELD_SONG_LEN			"SongLen"
#define APE_TAG_FIELD_SIZE				"Size"
#define APE_TAG_FIELD_FILE_OWNER		"FileOwner"
#define APE_TAG_FIELD_NET_RADIO_STATION	"NetRadioStation"
#define APE_TAG_FIELD_NET_RADIO_OWNER	"NetRadioOwner"
#define APE_TAG_FIELD_ISRC				"ISRC"

#define APE_TAG_FIELD_ARTIST_WWW			"WWWArtist"
#define APE_TAG_FIELD_COPYRIGHT_WWW			"WWWCopyright"
#define APE_TAG_FIELD_PUBLISHER_WWW			"WWWPublisher"
#define APE_TAG_FIELD_AUDIO_FILE_WWW		"WWWAudioFile"
#define APE_TAG_FIELD_AUDIOSOURCE_WWW		"WWWAudioSource"
#define APE_TAG_FIELD_COMMERCIAL_INFO_WWW	"WWWCommercialInfo"
#define APE_TAG_FIELD_RADIO_PAGE_WWW		"WWWRadioPage"
#define APE_TAG_FIELD_PAYMENT_WWW			"WWWPayment"
#define APE_TAG_FIELD_USER_WWW				"WWWUser"

#define APE_TAG_FIELD_REPLAYGAIN_TRACK_GAIN			"replaygain_track_gain"
#define APE_TAG_FIELD_REPLAYGAIN_TRACK_PEAK			"replaygain_track_peak"
#define APE_TAG_FIELD_REPLAYGAIN_ALBUM_GAIN			"replaygain_album_gain"
#define APE_TAG_FIELD_REPLAYGAIN_ALBUM_PEAK			"replaygain_album_peak"
#define APE_TAG_FIELD_REPLAYGAIN_GAIN_MINMAX		"mp3gain_minmax"
#define APE_TAG_FIELD_REPLAYGAIN_GAIN_ALBUM_MINMAX	"mp3gain_album_minmax"
#define APE_TAG_FIELD_REPLAYGAIN_GAIN_UNDO			"mp3gain_undo"

#define APE_TAG_FIELD_L_REPLAYGAIN_TRACK_GAIN			L"replaygain_track_gain"
#define APE_TAG_FIELD_L_REPLAYGAIN_TRACK_PEAK			L"replaygain_track_peak"
#define APE_TAG_FIELD_L_REPLAYGAIN_ALBUM_GAIN			L"replaygain_album_gain"
#define APE_TAG_FIELD_L_REPLAYGAIN_ALBUM_PEAK			L"replaygain_album_peak"
#define APE_TAG_FIELD_L_REPLAYGAIN_GAIN_MINMAX			L"mp3gain_minmax"
#define APE_TAG_FIELD_L_REPLAYGAIN_GAIN_ALBUM_MINMAX	L"mp3gain_album_minmax"
#define APE_TAG_FIELD_L_REPLAYGAIN_GAIN_UNDO			L"mp3gain_undo"

/*****************************************************************************************
Standard APE tag field values
*****************************************************************************************/
#define APE_TAG_GENRE_UNDEFINED			L"Undefined"

/*****************************************************************************************
ID3 v1.1 tag
*****************************************************************************************/
#define ID3_TAG_BYTES	128

/*
struct ID3_TAG
{
	char Header[3];			// should equal 'TAG'
	char Title[30];			// title
	char Artist[30];		// artist
	char Album[30];			// album
	char Year[4];			// year
	char Comment[29];		// comment
	unsigned char Track;	// track
	unsigned char Genre;	// genre
};
*/

/*****************************************************************************************
Footer (and header) flags
*****************************************************************************************/
#define APE_TAG_FLAG_CONTAINS_HEADER			(1U << 31)
#define APE_TAG_FLAG_CONTAINS_FOOTER			(1U << 30)
#define APE_TAG_FLAG_IS_HEADER					(1U << 29)

#define APE_TAG_FLAGS_DEFAULT					(APE_TAG_FLAG_CONTAINS_FOOTER)

/*****************************************************************************************
Tag field flags
*****************************************************************************************/
#define TAG_FIELD_FLAG_READ_ONLY				(1 << 0)

#define TAG_FIELD_FLAG_DATA_TYPE_MASK			(6)
#define TAG_FIELD_FLAG_DATA_TYPE_TEXT_UTF8		(0 << 1)
#define TAG_FIELD_FLAG_DATA_TYPE_BINARY			(1 << 1)
#define TAG_FIELD_FLAG_DATA_TYPE_EXTERNAL_INFO	(2 << 1)
#define TAG_FIELD_FLAG_DATA_TYPE_RESERVED		(3 << 1)

/*****************************************************************************************
The footer at the end of APE tagged files (can also optionally be at the front of the tag)
*****************************************************************************************/
#define APE_TAG_FOOTER_BYTES	32

struct APE_TAG_FOOTER
{
	char m_cID[8];				// should equal 'APETAGEX'	
	unsigned int m_nVersion;	// equals CURRENT_APE_TAG_VERSION
	unsigned int m_nSize;		// the complete size of the tag, including this footer (excludes header)
	unsigned int m_nFields;		// the number of fields in the tag
	unsigned int m_nFlags;		// the tag flags
	char m_cReserved[8];		// reserved for later use (must be zero)
};

