
//
//  ID3v1^O擾
//
//  Written by Otachan
//  http://otachan.com/
//

#include "stdafx.h"

#include "wa_ipc.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "TagInfo.h"

extern const char*	GenreList[];

bool
Tag::GetTitleFromID3v1(_TagInfo* TagInfo)
{
	::SetLastError(NO_ERROR);

	HANDLE	hF = ::CreateFile(
							TagInfo->FileName,
							GENERIC_READ,
							FILE_SHARE_READ,
							NULL,
							OPEN_EXISTING,
							FILE_FLAG_RANDOM_ACCESS,
							NULL);

	if(::GetLastError() != NO_ERROR) return false;

	DWORD	FileSize = ::GetFileSize(hF, NULL);

	if(FileSize < sizeof(id3tag)) {
		::CloseHandle(hF);
		return false;
	}

	id3tag	ID3tag;
	DWORD	ReadByte;

	memset(ID3tag.tag, '\0', 3);
	::SetFilePointer(hF, FileSize - sizeof ID3tag, NULL, FILE_BEGIN);
	::ReadFile(hF, &ID3tag, sizeof ID3tag, &ReadByte, NULL);

	::CloseHandle(hF);

	if((*ID3tag.tag != 'T') || (*(ID3tag.tag + 1) != 'A') || (*(ID3tag.tag + 2) != 'G')) return false;

	int		Len;

	Len = ::MultiByteToWideChar(
							CP_ACP,
							0,
							ID3tag.title,
							30,
							TagInfo->Title,
							MAX_MUSICTEXT);
	EraseSpace(TagInfo->Title, Len);

	Len = ::MultiByteToWideChar(
							CP_ACP,
							0,
							ID3tag.artist,
							30,
							TagInfo->Artist,
							MAX_MUSICTEXT);
	EraseSpace(TagInfo->Artist, Len);

	Len = ::MultiByteToWideChar(
							CP_ACP,
							0,
							ID3tag.album,
							30,
							TagInfo->Album,
							MAX_MUSICTEXT);
	EraseSpace(TagInfo->Album, Len);

	unsigned char	Track;

	if((ID3tag.comment[28] == '\0') && (Track = ID3tag.comment[29])) {
		_itow_s(Track, TagInfo->Track, MAX_MUSICTEXT, 10);
	} else {
		*TagInfo->Track = L'\0';
	}

	Len = ::MultiByteToWideChar(
							CP_ACP,
							0,
							ID3tag.year,
							4,
							TagInfo->Year,
							MAX_MUSICTEXT);
	EraseSpace(TagInfo->Year, Len);

	if(ID3tag.genre < MAX_GENRE) {
		Strcpy(TagInfo->Genre, MAX_MUSICTEXT, GenreList[ID3tag.genre]);
	} else {
		*TagInfo->Genre = L'\0';
	}

	Len = ::MultiByteToWideChar(
							CP_ACP,
							0,
							ID3tag.comment,
							(ID3tag.comment[28] == '\0') ? 28 : 30,
							TagInfo->Comment,
							MAX_MUSICTEXT);
	EraseSpace(TagInfo->Comment, Len);

	*TagInfo->Composer = L'\0';
	*TagInfo->OrgArtist = L'\0';
	*TagInfo->Copyright = L'\0';
	*TagInfo->Encoder = L'\0';

	return true;
}

