/**
 * 
 */
package org.blueforest.rockhouse.encoding_converter.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.blueforest.rockhouse.encoding_converter.Activator;
import org.blueforest.rockhouse.encoding_converter.popup.actions.wizard.ConvertEncodingWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.WizardDialog;

/**
 * @author akira saito
 *
 */
public class ConvertEncodingAction extends ConvertAction {
	private ConvertEncodingParameter convertParam;
	
	/**
	 * 
	 */
	public ConvertEncodingAction() {
	}
	
	@Override
	protected boolean before(IAction action) throws CoreException {
		this.convertParam = this.actionIdToCharset(action);
		if (this.convertParam == null) {
			return false;
		}
		return true;
	}

	private String defaultString(String p1, String defaultString) {
		if (p1 == null || p1.length() == 0) {
			return defaultString;
		}
		return p1;
	}
	@Override
	protected boolean convert(IAction action, IFile file) throws CoreException {
		assert(convertParam != null);

		try {
			String fromCharsetName = defaultString(this.convertParam.getFromEncoding(), file.getCharset());
			String toCharsetName = defaultString(this.convertParam.getToEncoding(), file.getProject().getDefaultCharset());
			this.printConsole(fromCharsetName);
			if (this.convertParam.isOnlyReport()) {
				return false;
			}
			
			this.printConsole("-> " + toCharsetName + " ");

			if (fromCharsetName.equals(toCharsetName)) {
				this.printConsole("skipped. charset is equals.");
				return false;
			}
			
			Reader is = new InputStreamReader(file.getContents(), fromCharsetName);
			
			CharArrayWriter os = new CharArrayWriter();
			do {
				int c = is.read();
				if (c == -1) break;
				os.write(c);
			} while (true);
			is.close();
			
			InputStream convertedInStream = new ByteArrayInputStream(os.toString().getBytes(toCharsetName));
			file.setContents(convertedInStream, 0, null);
			file.setCharset(this.convertParam.getToEncoding(), null); // toCharsetName変数を利用すると「デフォルト」に設定出来ない。
			return true;
			
		} catch (IOException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "", e);
			throw new CoreException(status);
		}
	}

	private ConvertEncodingParameter actionIdToCharset(IAction action) {
		
		String id = action.getId();
		if (id.contains(".to_utf-8")) {
			ConvertEncodingParameter param = new ConvertEncodingParameter();
			param.setFromEncoding(null);
			param.setToEncoding("UTF-8");
			return param;

		} else if (id.contains(".to_project_default")) {
			ConvertEncodingParameter param = new ConvertEncodingParameter();
			param.setFromEncoding(null);
			param.setToEncoding(null);
			return param;

		} else if (id.contains(".custom")) {
			ConvertEncodingWizard wizard = new ConvertEncodingWizard();
			WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
			int returnCode = dialog.open();
//			System.out.println("returnCode=" + returnCode);

			if (returnCode == WizardDialog.CANCEL) {
				return null;
			}
			
			return wizard.getConvertParameter();

		} else {
			throw new IllegalArgumentException("unknown action id. id=" + action.getId());
		}
	}

}
