/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.popup.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.sourceforge.edocbook.Activator;
import jp.sourceforge.edocbook.EDocbookRuntimeException;
import jp.sourceforge.edocbook.model.DocbookFile;
import jp.sourceforge.edocbook.model.ResultFile;
import jp.sourceforge.edocbook.model.XslFile;
import jp.sourceforge.edocbook.transform.HtmlTransformer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractHtmlCreateAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private XslFile xslFile;
    private HtmlTransformer transformer = new HtmlTransformer(this.createXslFile());

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    private IFile getSelection() {
        ISelectionProvider selectionProvider = this.part.getSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selectionProvider.getSelection();
            if (!(structuredSelection.getFirstElement() instanceof IResource)) {
                return null;
            }
            IResource resource = (IResource)structuredSelection.getFirstElement();
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            return (IFile)resource;
        }
        if (this.part instanceof IEditorPart) {
            Object obj = ((IEditorPart)this.part).getEditorInput().getAdapter(IFile.class);
            if (obj == null) {
                System.out.println("obj is null.");
                return null;
            }
            return (IFile)obj;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected DocbookFile getSourceFile() {
        IFile iFile = this.getSelection();
        if (iFile != null) {
            File file = new File(iFile.getLocation().toString());
            return new DocbookFile(file);
        }
        return null;
    }

    protected void reflesh() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }

    public void run(IAction action) {
        try {
            DocbookFile source = this.getSourceFile();
            if (source == null) {
                return;
            }
            ResultFile result = new ResultFile(source.getReplaceExtensionFile("html"));
            this.transformer.transform(source, result);
            this.reflesh();
        }
        catch (EDocbookRuntimeException e) {
            Activator.showErrorDialog(e);
        }
    }

    protected abstract XslFile createXslFile();

    protected Properties createOutputProperties() {
        Properties prop = new Properties();
        prop.put("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
        prop.put("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
        prop.put("method", "html");
        prop.put("indent", "yes");
        prop.put("encoding", "UTF-8");
        return prop;
    }

    protected Map<String, Object> createParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("use.extensions", "1");
        return params;
    }
}

