/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.transform;

import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import jp.sourceforge.edocbook.EDocbookRuntimeException;
import jp.sourceforge.edocbook.model.DocbookFile;
import jp.sourceforge.edocbook.model.ResultFile;
import jp.sourceforge.edocbook.model.XslFile;

public class HtmlTransformer {
    private XslFile xsl;
    private Transformer transformer;

    public HtmlTransformer(XslFile xsl) {
        this.xsl = xsl;
        this.transformer = this.createTransformer();
    }

    public void transform(DocbookFile source, ResultFile result) {
        try {
            System.out.println(source.toString());
            System.out.println(result.toString());
            assert (this.transformer != null);
            this.transformer.setOutputProperties(this.xsl.getOutputProperties());
            this.setupParameter(this.transformer);
            this.transformer.transform(source.getSource(), result.getResult());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }

    private void setupParameter(Transformer transformer) {
        for (Map.Entry<String, Object> entry : this.xsl.getParameters().entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }

    private Transformer createTransformer() {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer(this.xsl.getSource());
            assert (transformer != null);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }
}

