/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.cdt;

import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EE2EIndentMake
extends EE2EIndentBehavior {
    public static final int INDENT_LEN = 4;

    protected void doIndent(int offset, IDocument document) throws BadLocationException {
        offset = EE2ELispBase.get().beginningOfLine(offset, document);
        int len = EE2ELispBase.get().indentLen(offset, document);
        this.indentTo(offset, len += 4, document);
    }

    protected void indentTo(int offset, int size, IDocument document) throws BadLocationException {
        int begin;
        if (size < 0) {
            size = 0;
        }
        int realSize = 0;
        int len = 0;
        boolean tabNotUsedFlag = true;
        int i = begin = EE2ELispBase.get().beginningOfLine(offset, document);
        while (i < document.getLength()) {
            if (document.getChar(i) == ' ') {
                ++realSize;
                ++len;
            } else {
                if (document.getChar(i) != '\t') break;
                ++realSize;
                len += 4;
                tabNotUsedFlag = false;
            }
            ++i;
        }
        if (size == len && tabNotUsedFlag) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        int i2 = 0;
        while (i2 < size) {
            buff.append('\t');
            i2 += 4;
        }
        document.replace(offset, realSize, buff.toString());
    }
}

