/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion;
import jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView;
import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.relax.EE2RAttribute;
import jp.sourceforge.projects.ee2e.core.relax.EE2RDefvar;
import jp.sourceforge.projects.ee2e.core.relax.EE2REnumeration;
import jp.sourceforge.projects.ee2e.core.relax.EE2REnv;
import jp.sourceforge.projects.ee2e.core.relax.EE2RStructureList;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTagext;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EDependCompletent
implements EE2EMenuBehavior,
EE2EDisplayCompletion {
    public static final String SECTION = "section";
    public static final String BEGIN = "begin";
    public static final String LEARGE = "learge";
    public static final String BIG = "big";
    public static final String RETURN = "return";
    public static final String ENUMULATION = "enumeration";
    public static final String INTEGER = "integer";
    public static final String FILE = "file";
    public static final String FILE_NAME = "filename";
    public static final String XML_FILE_NAME = "xml-file-name";
    public static final String FOLDER = "folder";
    public static final String XML_SAME_ALIST = "xml-same-alist";
    public static final String XI_XPAHT = "xi-xpath";
    public static final String HTML_IMAGE_FILE_NAME = "html-image-file-name";
    public static final String HTML_IMAGE_ALT = "html-image-alt";
    public static final String HTML_IMAGE_WIDTH = "html-image-width";
    public static final String HTML_IMAGE_HEIGHT = "html-image-height";
    public static final String HTML_SET_REV_LINK = "html-set-rev-link";
    public static final String HTML_SET_REL_LINK = "html-set-rel-link";
    public static final String HTML_SET_CSS_STYLE = "html-set-css-style";
    public static final String HTML_SET_META_TYPES = "html-set-meta-types";
    public static final String HTML_SET_HTTP_EQUIV = "html-set-http-equiv";
    public static final String HTML_SET_CONTENT = "html-set-content";
    public static final String JSP_SAME_ALIST = "jsp-same-alist";
    public static final String JSP_ACTION_ALIST = "jsp-action-alist";
    public static final String SDOC_IMAGE_STYLE = "sdoc-image-style";
    public static final String JSP_JSTL_EL = "jsp-jstl-el";
    public static final String JSP_JSPL_VAR_SOURCE = "jsp-jspl-var-source";
    public static final String META_KEYWORD = "keywords";
    public static final String META_AUTHER = "author";
    public static final String META_COPYRIGHT = "copyright";
    public static final String META_DATE = "date";
    public static final String META_GENERATOR = "generator";
    public static final String META_CONTENT = "Content-Type";
    public static final String META_REFRESH = "refresh";
    public static final String META_STYLE_SHEET = "stylesheet";
    public static final String XI_PATH_NINJA = "xi-path-ninja";
    public static final String XI_PATH_FORMULA = "xi-path-formula";
    public static final String HTML_CHARSET = "html-charset";
    public static final String HTML_LINK_TYPES = "html-link-types";
    public static final String JSP_JSPL_PATH_FORMULA = "jsp-jstl-path-formula";
    public static final String JSP_JSPL_OBJECT = "jsp-jstl-object";
    public static final String GENERATOR = "EE2E / http://park.ruru.ne.jp/ando/work/who/ee2e/";
    private EE2RStructureList strListIns;
    private EE2EIndentBehavior indentBehavior;
    private String oneString;
    private EE2RDefvar defvarIns;
    private EE2RTag nextTag;
    private EE2RAttribute nextAttribute;
    private AbstractTextEditor editorIns;
    private String tagCompletent;
    private LinkedList argList;
    private String imageFileName;
    private long imageLength;
    private int imageWidth;
    private int imageHeight;
    private boolean tagExtFlag;

    public EE2EDependCompletent(EE2RStructureList structureList, EE2EIndentBehavior indentBehavior, String oneString) {
        this.strListIns = structureList;
        this.indentBehavior = indentBehavior;
        this.oneString = oneString;
        this.imageFileName = null;
        this.imageLength = -1L;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.tagExtFlag = false;
    }

    public void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        this.initialize();
        this.editorIns = editor;
        if (this.strListIns == null) {
            EE2EDebug.printf(1, "doBehavior/getStructureList is null");
            return;
        }
        this.defvarIns = EE2EToolkit.get().getDefvar(this.strListIns);
        if (this.defvarIns == null) {
            EE2EDebug.printf(10, "one completention");
            this.finalReturnAction();
            return;
        }
        EE2EMiniBufferView.showEE2EDisplayCompletion(this);
    }

    public String getTitleText() {
        if (this.tagCompletent == null) {
            return "EE2E Identifer(default:" + this.strListIns.getDefault() + ")";
        }
        return "EE2E Argument(" + EE2EToolkit.get().getAttribute(this.nextTag, this.argList.size()).getName() + "/" + this.nextTag.getName() + ")";
    }

    public Collection getTagList() {
        if (this.nextTag == null) {
            return null;
        }
        LinkedList<String> col = new LinkedList<String>();
        int i = 0;
        while (i < this.nextTag.getAttributeCount()) {
            EE2RAttribute attr = this.nextTag.getAttribute(i);
            String answer = attr.getName();
            if (attr.getEnumerationCount() > 0) {
                EE2REnumeration enumeration = attr.getEnumeration(0);
                answer = enumeration.getName() != null && !enumeration.getName().equals("") ? String.valueOf(answer) + " / " + enumeration.getName() + "..." : String.valueOf(answer) + " (" + enumeration.getRef() + ")";
            }
            col.add(answer);
            ++i;
        }
        return col;
    }

    public String getTagListSelect() {
        if (this.nextTag == null) {
            return null;
        }
        return this.nextAttribute.getName();
    }

    public Collection allCompletions(String string) {
        if (this.tagCompletent == null) {
            if (!this.tagExtFlag) {
                this.tagExtFlag = true;
                this.checkTagExtFlag(this.strListIns);
            }
            return EE2EToolkit.get().getTagSet(this.defvarIns);
        }
        return this.getElementSet(this.nextAttribute, this.editorIns, string);
    }

    public void returnAction(String string) {
        if (this.tagCompletent == null) {
            this.argList = new LinkedList();
            if (string == null || string.equals("")) {
                this.tagCompletent = this.strListIns.getDefault();
            } else {
                this.tagCompletent = string;
                this.strListIns.setDefault(this.tagCompletent);
            }
            this.nextTag = EE2EToolkit.get().getTag(this.defvarIns, this.tagCompletent);
        } else {
            this.argList.add(string);
        }
        this.nextAttribute = EE2EToolkit.get().getAttribute(this.nextTag, this.argList.size());
        if (this.nextAttribute == null) {
            this.finalReturnAction();
        }
    }

    protected void finalReturnAction() {
        EE2EDebug.printf(5, "finalReturnAction");
        if (this.editorIns == null) {
            EE2EDebug.printf(3, "[return] action -- editorIns editable");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        if (!this.editorIns.isEditable()) {
            EE2EDebug.printf(3, "[return] action -- editable");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        IDocument document = EE2EToolkit.get().getEditorToDocument(this.editorIns);
        if (this.editorIns.getDocumentProvider() == null) {
            EE2EDebug.printf(3, "not getDocumentProvider()!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        if (document == null) {
            EE2EDebug.printf(3, "not document!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        ISelection selection = this.editorIns.getSelectionProvider().getSelection();
        if (selection == null) {
            EE2EDebug.printf(3, "not selection!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        if (!(selection instanceof ITextSelection)) {
            EE2EDebug.printf(3, "not instanceof ITextSelection!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        try {
            EE2EToolkit.get().doStructure(this.strListIns, this.argList, this.nextTag, this.indentBehavior, this.editorIns, document, textSelection);
        }
        catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException!!" + e.getMessage());
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        EE2EMiniBufferView.removeEE2EDisplayCompletion();
        EE2EDebug.printf(3, "finalReturnAction:dispose");
    }

    public String getText() {
        return EE2EPlugin.getResourceString(String.valueOf(EE2EPlugin.getResourceString("action." + this.strListIns.getType())) + "(&" + this.oneString + ")");
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action." + this.strListIns.getType() + ".tooltip");
    }

    public void dispose() {
        this.initialize();
        EE2EDebug.printf(3, "[return] dispose");
    }

    protected Collection getElementSet(EE2RAttribute attr, AbstractTextEditor editor, String string) {
        if (attr == null) {
            return null;
        }
        if (attr.getRef() != null && !attr.getRef().equals("")) {
            attr = EE2EToolkit.get().getAttribute(attr.getRef());
        }
        TreeSet set = new TreeSet();
        if (attr.getEnumerationCount() > 0) {
            int i = 0;
            while (i < attr.getEnumerationCount()) {
                EE2REnumeration elem = attr.getEnumeration(i);
                this.getElementSetLoop(attr, elem, editor, string, set);
                ++i;
            }
        } else {
            this.getElementSetSameName(attr, null, editor, set);
        }
        return set;
    }

    protected void getElementSetLoop(EE2RAttribute attr, EE2REnumeration elem, AbstractTextEditor editor, String string, Collection col) {
        if (elem.getRef() == null || elem.getRef().equals("") || elem.getRef().equals(ENUMULATION)) {
            if (elem.getName() != null && !elem.getName().equals("")) {
                col.add(elem.getName());
            } else {
                EE2EDebug.printf(1, "enum error! name=" + attr.getName());
            }
        } else if (elem.getRef().equals(INTEGER)) {
            this.getElementSetInteger(string, col);
        } else if (elem.getRef().equals(FILE) || elem.getRef().equals(FILE_NAME) || elem.getRef().equals(XML_FILE_NAME)) {
            this.getElementSetFile(editor, string, col);
        } else if (elem.getRef().equals(FOLDER)) {
            this.getElementSetFolder(editor, string, col);
        } else if (elem.getRef().equals(XML_SAME_ALIST) || elem.getRef().equals(JSP_SAME_ALIST) || elem.getRef().equals(JSP_ACTION_ALIST)) {
            this.getElementSetSameName(attr, elem, editor, col);
        } else if (elem.getRef().equals(XI_XPAHT)) {
            this.getElementSetXiPath(editor, string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_FILE_NAME)) {
            this.getElementSetImageFile(editor, string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_ALT)) {
            this.getElementSetImageAlt(col);
        } else if (elem.getRef().equals(HTML_IMAGE_WIDTH)) {
            this.getElementSetImageWidth(string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_HEIGHT)) {
            this.getElementSetImageHeight(string, col);
        } else if (elem.getRef().equals(SDOC_IMAGE_STYLE)) {
            this.getElementSetImageSdocStyle(col);
        } else if (elem.getRef().equals(HTML_SET_REV_LINK)) {
            this.getElementRevLink(col);
        } else if (elem.getRef().equals(HTML_SET_REL_LINK)) {
            this.getElementRelLink(col);
        } else if (elem.getRef().equals(HTML_SET_CSS_STYLE)) {
            this.getElementCssStyle(col);
        } else if (elem.getRef().equals(HTML_SET_META_TYPES)) {
            this.getElementSetMetaTypes(col);
        } else if (elem.getRef().equals(HTML_SET_HTTP_EQUIV)) {
            this.getElementSetHttpEquiv(col);
        } else if (elem.getRef().equals(HTML_SET_CONTENT)) {
            this.getElementSetContent(col);
        } else if (elem.getRef().equals(JSP_JSTL_EL)) {
            this.getElementSetJspJstlEl(editor, string, col);
        } else if (EE2EToolkit.get().getDefvar(elem.getRef()) != null) {
            EE2RDefvar newDefvar = EE2EToolkit.get().getDefvar(elem.getRef());
            int j = 0;
            while (j < newDefvar.getContentCount()) {
                IEE2RDefvarChoice choice = newDefvar.getContent(j);
                if (!(choice instanceof EE2REnumeration)) {
                    EE2EDebug.printf(3, "instanceof error ref=" + elem.getRef());
                } else {
                    EE2REnumeration next = (EE2REnumeration)choice;
                    this.getElementSetLoop(attr, next, editor, string, col);
                }
                ++j;
            }
        } else {
            EE2EDebug.printf(1, "not select! name=" + elem.getRef());
        }
    }

    protected void getElementSetInteger(String string, Collection col) {
        if (string == null) {
            string = "";
        }
        int i = 0;
        while (i < 9) {
            col.add(String.valueOf(string) + i);
            ++i;
        }
    }

    protected void getElementSetFile(AbstractTextEditor editor, String string, Collection col) {
        File target;
        File targetParent;
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            char ch = string.charAt(string.length() - 1);
            if (ch == '/' || ch == '\\') {
                string = String.valueOf(string) + "dummy.html";
            }
            string = EE2EToolkit.get().replaceFileSeparator(string);
            targetParent = new File(string).getParentFile();
        } else {
            targetParent = new File(".");
        }
        if (targetParent == null) {
            targetParent = new File(".");
        }
        if ((target = this.getTargetFile(editor, string, targetParent)) == null) {
            return;
        }
        File[] fileList = target.listFiles();
        if (fileList == null) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            File anserFile = new File(targetParent, fileList[i].getName().toString());
            String answer = anserFile.toString();
            if (fileList[i].isDirectory()) {
                answer = String.valueOf(answer) + "/";
            }
            answer = EE2EToolkit.get().replaceFileSeparator(answer);
            col.add(answer);
            if (2 < answer.length() && answer.charAt(0) == '.' && answer.charAt(1) == '/') {
                col.add(answer.substring(2));
            }
            ++i;
        }
    }

    protected File getTargetFile(AbstractTextEditor editor, String string, File targetParent) {
        File target;
        if (string.indexOf("://") > 0 || string.indexOf("mailto:") > 0 || string.indexOf("$") > 0 || string.indexOf("{") > 0 || string.indexOf("}") > 0) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            System.out.println("Invalid Input: Must be IFileEditorInput");
            return null;
        }
        IFileEditorInput fileInput = (IFileEditorInput)editorInput;
        if (string.indexOf(":") > 0 || string.length() > 0 && (string.charAt(0) == '/' || string.charAt(0) == '\\')) {
            target = targetParent;
        } else {
            IFile iFile = fileInput.getFile();
            IContainer container = iFile.getParent();
            IPath path = container.getLocation();
            File parentFile = path.toFile();
            target = new File(parentFile, targetParent.toString());
        }
        return target;
    }

    protected void getElementSetFolder(AbstractTextEditor editor, String string, Collection col) {
        this.getElementSetFile(editor, string, col);
    }

    protected void getElementSetSameName(EE2RAttribute attr, EE2REnumeration elem, AbstractTextEditor editor, Collection col) {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        try {
            if (elem == null || elem.getEnvCount() <= 0) {
                this.getElementSetSameNameSingle(attr.getName(), document, col);
                return;
            }
            int i = 0;
            while (i < elem.getEnvCount()) {
                EE2REnv env = elem.getEnv(i);
                this.getElementSetSameNameSingle(env.getName(), document, col);
                ++i;
            }
        }
        catch (BadLocationException e) {
            EE2EDebug.printf(1, "instanceof error e=" + e.getMessage());
        }
    }

    protected void getElementSetSameNameSingle(String target, IDocument document, Collection col) throws BadLocationException {
        String findString = String.valueOf(target) + "=\"";
        int nowResult = 0;
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        IRegion resion;
        while ((nowResult = (resion = adapter.search(nowResult, findString, true, true, false, false)).getOffset()) >= 0) {
            int len = EE2ELispBase.get().findCharsForward(nowResult += findString.length(), "\"<>\r\n", document);
            String data = document.get(nowResult, len - nowResult);
            col.add(data);
            nowResult = len + 1;
        }
        return;
    }

    protected void getElementSetXiPath(AbstractTextEditor editor, String string, Collection col) {
        int lastOffset = this.getLastOffset(string, " $=@\\/*|&()[]{}<>!'#%~^+-,?:;");
        EE2RAttribute attr = new EE2RAttribute();
        if (lastOffset < 0) {
            String plusData = "";
            col.add(String.valueOf(plusData) + "$");
            col.add(String.valueOf(plusData) + "/");
        } else {
            String plusData = string.substring(0, lastOffset + 1);
            char lastChar = string.charAt(lastOffset);
            if (lastChar == ' ' || lastChar == ')' || lastChar == '}' || lastChar == ']') {
                ArrayList formulaCollection = new ArrayList();
                this.getDefvarData(XI_PATH_FORMULA, formulaCollection);
                Iterator ite = formulaCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = String.valueOf(plusData) + (String)ite.next() + " ";
                    col.add(sameName);
                }
                col.add(String.valueOf(plusData) + "$");
                col.add(String.valueOf(plusData) + "/");
            } else if (lastChar == '/') {
                ArrayList tagCollection = new ArrayList();
                this.getElementSetSameTag(editor, tagCollection);
                Iterator ite = tagCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = String.valueOf(plusData) + (String)ite.next();
                    col.add(sameName);
                }
            } else if (lastChar == '$') {
                ArrayList targetCollection = new ArrayList();
                attr.setName("name");
                this.getElementSetSameName(attr, null, editor, targetCollection);
                attr.setName("item");
                this.getElementSetSameName(attr, null, editor, targetCollection);
                this.getDefvarData(XI_PATH_NINJA, targetCollection);
                Iterator ite = targetCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = String.valueOf(plusData) + (String)ite.next();
                    col.add(sameName);
                }
            } else {
                col.add(String.valueOf(plusData) + " $");
                col.add(String.valueOf(plusData) + " /");
            }
        }
        attr.setName("select");
        this.getElementSetSameName(attr, null, editor, col);
    }

    protected void getElementSetSameTag(AbstractTextEditor editor, Collection col) {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        try {
            int nowResult = 0;
            String findString = "<";
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
            while (true) {
                IRegion resion;
                if ((nowResult = (resion = adapter.search(nowResult, findString, true, true, false, false)).getOffset()) < 0) {
                    return;
                }
                char ch = document.getChar(nowResult += findString.length());
                if (ch == '/' || ch == '!' || ch == '?' || ch == '%' || ch == '@' || ch == '[') continue;
                int len = EE2ELispBase.get().findCharsForward(nowResult, " <>\t\r\n", document);
                String data = document.get(nowResult, len - nowResult);
                col.add(data);
                nowResult = len + 1;
            }
        }
        catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException e=" + e.getMessage());
            return;
        }
    }

    protected int getLastOffset(String target, String charString) {
        if (target == null) {
            return -1;
        }
        int answer = -1;
        int i = 0;
        while (i < charString.length()) {
            char ch = charString.charAt(i);
            int j = target.length() - 1;
            while (j >= 0) {
                if (target.charAt(j) == ch) {
                    if (answer >= j) break;
                    answer = j;
                    break;
                }
                --j;
            }
            ++i;
        }
        return answer;
    }

    protected void getElementSetImageFile(AbstractTextEditor editor, String string, Collection col) {
        this.getElementSetFile(editor, string, col);
    }

    protected void getElementSetImageAlt(Collection col) {
        if (this.imageLength < 0L) {
            this.setImageData();
        }
        if (this.imageLength == 0L) {
            if (this.imageFileName != null) {
                col.add(this.imageFileName);
            }
            return;
        }
        String answer = String.valueOf(Integer.toString(this.imageHeight)) + "x" + Integer.toString(this.imageWidth) + "(" + Long.toString(this.imageLength) + "bytes)";
        col.add(answer);
    }

    protected void getElementSetImageWidth(String string, Collection col) {
        if (this.imageLength < 0L) {
            this.setImageData();
        }
        if (this.imageLength == 0L) {
            this.getElementSetInteger(string, col);
            return;
        }
        String answer = Integer.toString(this.imageWidth);
        col.add(answer);
    }

    protected void getElementSetImageHeight(String string, Collection col) {
        if (this.imageLength < 0L) {
            this.setImageData();
        }
        if (this.imageLength == 0L) {
            this.getElementSetInteger(string, col);
            return;
        }
        String answer = Integer.toString(this.imageHeight);
        col.add(answer);
    }

    protected void getElementSetImageSdocStyle(Collection col) {
        if (this.imageLength < 0L) {
            this.setImageData();
        }
        if (this.imageLength == 0L) {
            if (this.imageFileName != null) {
                col.add(this.imageFileName);
            }
            return;
        }
        String answer = "width:" + Integer.toString(this.imageWidth) + ";height:" + Integer.toString(this.imageHeight);
        col.add(answer);
    }

    protected void getElementRevLink(Collection col) {
        this.getDefvarData(HTML_LINK_TYPES, col);
        col.add(META_STYLE_SHEET);
    }

    protected void getElementRelLink(Collection col) {
        String types = this.getMetaTypes();
        if (types != null && !types.equals("")) {
            return;
        }
        this.getDefvarData(HTML_LINK_TYPES, col);
    }

    protected void getElementCssStyle(Collection col) {
        String types = this.getMetaTypes();
        if (types == null || !types.equals(META_STYLE_SHEET)) {
            return;
        }
        col.add("text/css");
    }

    protected void getElementSetMetaTypes(Collection col) {
        col.add(META_KEYWORD);
        col.add(META_AUTHER);
        col.add(META_COPYRIGHT);
        col.add(META_DATE);
        col.add(META_GENERATOR);
    }

    protected void getElementSetHttpEquiv(Collection col) {
        String types = this.getMetaTypes();
        if (types != null) {
            return;
        }
        col.add(META_REFRESH);
        col.add(META_CONTENT);
    }

    protected void getElementSetContent(Collection col) {
        String types = this.getMetaTypes();
        if (types == null) {
            return;
        }
        if (types.equals(META_KEYWORD)) {
            EE2EDebug.printf(10, "target=keywords");
        } else if (types.equals(META_AUTHER)) {
            EE2EDebug.printf(10, "target=author");
        } else if (types.equals(META_COPYRIGHT)) {
            EE2EDebug.printf(10, "target=copyright");
        } else if (types.equals(META_DATE)) {
            EE2EDebug.printf(10, "target=date");
            Date date = new Date();
            String dateString = DateFormat.getDateInstance().format(date);
            col.add(dateString);
        } else if (types.equals(META_GENERATOR)) {
            EE2EDebug.printf(10, "target=generator");
            col.add(GENERATOR);
        } else if (types.equals(META_REFRESH)) {
            EE2EDebug.printf(10, "target=refresh");
            this.getElementSetInteger(";URL=", col);
        } else if (types.equals(META_CONTENT)) {
            EE2EDebug.printf(10, "target=Content-Type");
            this.getDefvarData(HTML_CHARSET, col);
        } else {
            EE2EDebug.printf(10, "under stand! name=" + types);
        }
    }

    protected void getElementSetJspJstlEl(AbstractTextEditor editor, String string, Collection col) {
        String sameName;
        Iterator ite;
        int lastOffset = this.getLastOffset(string, " =$@\\/*|&()[]{}<>!'#%~^+-,?:;");
        EE2RAttribute attr = new EE2RAttribute();
        if (lastOffset < 0) {
            return;
        }
        String plusData = string.substring(0, lastOffset + 1);
        char lastChar = string.charAt(lastOffset);
        if (lastChar == '$') {
            col.add(String.valueOf(plusData) + "{");
            return;
        }
        if (lastChar == ' ') {
            ArrayList formulaCollection = new ArrayList();
            this.getDefvarData(JSP_JSPL_PATH_FORMULA, formulaCollection);
            ite = formulaCollection.iterator();
            while (ite.hasNext()) {
                sameName = String.valueOf(plusData) + (String)ite.next() + " ";
                col.add(sameName);
            }
        }
        ArrayList targetCollection = new ArrayList();
        attr.setName("var");
        this.getElementSetSameName(attr, null, editor, targetCollection);
        this.getDefvarData(JSP_JSPL_OBJECT, targetCollection);
        ite = targetCollection.iterator();
        while (ite.hasNext()) {
            sameName = String.valueOf(plusData) + (String)ite.next();
            col.add(sameName);
        }
        targetCollection.clear();
        attr.setName("varSource");
        this.getElementSetSameName(attr, null, editor, targetCollection);
        if (targetCollection.size() <= 0) {
            return;
        }
        ArrayList varSourceCollection = new ArrayList();
        this.getDefvarData(JSP_JSPL_VAR_SOURCE, varSourceCollection);
        ite = targetCollection.iterator();
        while (ite.hasNext()) {
            String sameName2 = String.valueOf(plusData) + (String)ite.next();
            Iterator varSourceIte = varSourceCollection.iterator();
            while (varSourceIte.hasNext()) {
                String varSource = String.valueOf(sameName2) + (String)varSourceIte.next();
                col.add(varSource);
            }
        }
    }

    protected void getDefvarData(String string, Collection col) {
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(string);
        int i = 0;
        while (i < defvar.getContentCount()) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2REnumeration) {
                EE2REnumeration emu = (EE2REnumeration)choice;
                col.add(emu.getName());
            }
            ++i;
        }
    }

    protected String getMetaTypes() {
        String metaTypes = null;
        int i = 0;
        while (i < this.argList.size() && metaTypes == null) {
            EE2RAttribute attribute = EE2EToolkit.get().getAttribute(this.nextTag, i);
            int j = 0;
            while (j < attribute.getEnumerationCount() && metaTypes == null) {
                String buff;
                EE2REnumeration eE2REnumeration = attribute.getEnumeration(j);
                if (eE2REnumeration.getRef() != null && (eE2REnumeration.getRef().equals(HTML_SET_META_TYPES) || eE2REnumeration.getRef().equals(HTML_SET_REV_LINK) || eE2REnumeration.getRef().equals(HTML_SET_REL_LINK) || eE2REnumeration.getRef().equals(HTML_SET_HTTP_EQUIV)) && (buff = (String)this.argList.get(i)) != null && !buff.equals("")) {
                    metaTypes = buff;
                }
                ++j;
            }
            ++i;
        }
        return metaTypes;
    }

    protected boolean setImageData() {
        this.imageLength = 0L;
        String fileName = null;
        int i = 0;
        while (i < this.argList.size() && fileName == null) {
            EE2RAttribute attribute = EE2EToolkit.get().getAttribute(this.nextTag, i);
            int j = 0;
            while (j < attribute.getEnumerationCount() && fileName == null) {
                EE2REnumeration eE2REnumeration = attribute.getEnumeration(j);
                if (eE2REnumeration.getRef() != null && eE2REnumeration.getRef().equals(HTML_IMAGE_FILE_NAME)) {
                    fileName = (String)this.argList.get(i);
                }
                ++j;
            }
            ++i;
        }
        if (fileName == null) {
            return false;
        }
        File targetParent = new File(fileName);
        File target = this.getTargetFile(this.editorIns, fileName, targetParent);
        if (target == null) {
            return false;
        }
        if (!target.isFile()) {
            return false;
        }
        this.imageLength = target.length();
        Frame doutFrame = new Frame();
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(target.toURL());
            MediaTracker mediatracker = new MediaTracker(doutFrame);
            mediatracker.addImage(image, 0);
            mediatracker.waitForID(0);
            this.imageHeight = image.getHeight(doutFrame);
            this.imageWidth = image.getWidth(doutFrame);
        }
        catch (MalformedURLException malformedURLException) {
            doutFrame.dispose();
            return false;
        }
        catch (InterruptedException interruptedException) {
            doutFrame.dispose();
            return false;
        }
        doutFrame.dispose();
        return true;
    }

    protected void checkTagExtFlag(EE2RStructureList structureList) {
        IDocument document = EE2EToolkit.get().getEditorToDocument(this.editorIns);
        if (document == null) {
            return;
        }
        try {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
            int i = 0;
            while (i < structureList.getTagextCount()) {
                IRegion resion;
                EE2RTagext tagext = structureList.getTagext(i);
                if (tagext != null && (resion = adapter.search(0, tagext.getTarget(), true, true, false, false)).getOffset() >= 0) {
                    String tagref = tagext.getTagref();
                    this.addTagextToDefvar(structureList, tagref);
                    structureList.setTagext(i, null);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException e" + e.getMessage());
        }
    }

    private void addTagextToDefvar(EE2RStructureList structureList, String tagref) {
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(structureList);
        if (defvar == null) {
            return;
        }
        EE2RDefvar targetDefvar = EE2EToolkit.get().getDefvar(tagref);
        LinkedList<IEE2RDefvarChoice> list = new LinkedList<IEE2RDefvarChoice>();
        int i = 0;
        while (i < defvar.getContentCount()) {
            list.add(defvar.getContent(i));
            ++i;
        }
        i = 0;
        while (i < targetDefvar.getContentCount()) {
            list.add(targetDefvar.getContent(i));
            ++i;
        }
        defvar.setContent(list.toArray(new IEE2RDefvarChoice[0]));
    }

    protected void initialize() {
        EE2EDebug.printf(3, "initialize");
        this.defvarIns = null;
        this.nextTag = null;
        this.nextAttribute = null;
        this.editorIns = null;
        this.tagCompletent = null;
        this.argList = null;
        this.imageFileName = null;
        this.imageLength = -1L;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.tagExtFlag = false;
    }
}

