/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentXML;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EE2EIndentXMLFormat
extends EE2EIndentXML {
    public EE2EIndentXMLFormat(int indentSize) {
        super(indentSize, true);
    }

    public final String getText() {
        return EE2EPlugin.getResourceString("action.format");
    }

    public final String getToolTipText() {
        return EE2EPlugin.getResourceString("action.format.tooltip");
    }

    protected void doIndent(int offset, IDocument document) throws BadLocationException {
        BadLocationException e = null;
        int i = 0;
        while (i < document.getNumberOfLines()) {
            try {
                int nextOffset = document.getLineOffset(i);
                super.doIndent(nextOffset, document);
            }
            catch (BadLocationException be) {
                e = be;
                EE2EDebug.printf(3, "BadLocationException!! line=" + i + " " + e.getMessage());
            }
            ++i;
        }
        if (e != null) {
            throw e;
        }
    }
}

