/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ESelectIndent;
import jp.sourceforge.projects.ee2e.core.relax.EE2RAttribute;
import jp.sourceforge.projects.ee2e.core.relax.EE2RDefvar;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2REnumeration;
import jp.sourceforge.projects.ee2e.core.relax.EE2RIteration;
import jp.sourceforge.projects.ee2e.core.relax.EE2RStructure;
import jp.sourceforge.projects.ee2e.core.relax.EE2RStructureList;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.xml.sax.SAXException;

public class EE2EToolkit {
    public static final String NO_TYPE = "no-type";
    public static final String INDENT = "indent";
    public static final String CURSOR = "cursor";
    public static final String KEYWORD = "keyword";
    public static final String ARGUMENT = "argument";
    public static final String REGION = "region";
    private static EE2EToolkit toolkit;
    private Map ee2eMap = new HashMap();
    private Map defvarMap = new HashMap();
    static /* synthetic */ Class class$0;

    public EE2EToolkit() {
        if (toolkit != null) {
            EE2EDebug.printf(1, "not single!!");
        }
    }

    public static EE2EToolkit get() {
        if (toolkit == null) {
            toolkit = new EE2EToolkit();
        }
        return toolkit;
    }

    public void doStructure(EE2RStructureList structureList, LinkedList argList, EE2RTag nextTag, EE2EIndentBehavior indentBehavior, AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        int offset;
        int saveOffset = offset = textSelection.getOffset();
        String region = document.get(offset, textSelection.getLength());
        document.replace(offset, textSelection.getLength(), "");
        int i = 0;
        while (i < structureList.getStructureCount()) {
            Position saveExcursion;
            EE2RStructure structure = structureList.getStructure(i);
            if (structure.getType() == null || structure.getType().equals("") || structure.getType().equals(NO_TYPE)) {
                StringBuffer sb = new StringBuffer(structure.getValue());
                while (sb.indexOf("\\n") >= 0) {
                    int of = sb.indexOf("\\n");
                    sb.replace(of, of + 2, "\n");
                }
                offset = this.pushString(document, offset, sb.toString());
            } else if (structure.getType().equals(INDENT)) {
                saveExcursion = new Position(offset);
                document.addPosition(saveExcursion);
                indentBehavior.doIndent(offset, document);
                offset = saveExcursion.getOffset();
                document.removePosition(saveExcursion);
            } else if (structure.getType().equals(KEYWORD)) {
                String work = nextTag == null ? structureList.getDefault() : nextTag.getName();
                offset = this.pushString(document, offset, work);
            } else if (structure.getType().equals(ARGUMENT)) {
                offset = this.doStructureArgument(structureList, argList, nextTag, document, offset);
            } else if (structure.getType().equals(CURSOR)) {
                saveExcursion = new Position(offset);
                document.addPosition(saveExcursion);
                indentBehavior.doBehavior(editor, document, textSelection);
                offset = saveExcursion.getOffset();
                document.removePosition(saveExcursion);
                saveOffset = offset;
            } else if (structure.getType().equals(REGION)) {
                offset = this.pushString(document, offset, region);
                region = null;
            } else {
                EE2EDebug.printf(3, "type not found!");
            }
            ++i;
        }
        offset = this.pushString(document, offset, region);
        EE2ESelectIndent sec = new EE2ESelectIndent(saveOffset);
        editor.getSelectionProvider().setSelection((ISelection)sec);
    }

    protected int doStructureArgument(EE2RStructureList structureList, LinkedList argList, EE2RTag nextTag, IDocument document, int offset) throws BadLocationException {
        String work;
        if (argList == null || argList.size() <= 0) {
            return offset;
        }
        boolean flag = false;
        int i = 0;
        while (i < argList.size()) {
            String attrValue = (String)argList.get(i);
            if (attrValue != null && !attrValue.equals("")) {
                if (!flag) {
                    work = structureList.getArgsep0();
                    offset = this.pushString(document, offset, work);
                } else {
                    work = structureList.getArgsep3();
                    offset = this.pushString(document, offset, work);
                }
                flag = true;
                work = this.getAttribute(nextTag, i).getName();
                offset = this.pushString(document, offset, work);
                work = structureList.getArgsep2();
                offset = this.pushString(document, offset, work);
                work = structureList.getArgsep1();
                offset = this.pushString(document, offset, work);
                work = attrValue;
                offset = this.pushString(document, offset, work);
                work = structureList.getArgsep4();
                offset = this.pushString(document, offset, work);
            }
            ++i;
        }
        if (flag) {
            work = structureList.getArgsep5();
            offset = this.pushString(document, offset, work);
        }
        return offset;
    }

    public int pushString(IDocument document, int offset, String arg) throws BadLocationException {
        if (arg == null || arg.equals("")) {
            return offset;
        }
        document.replace(offset, 0, arg);
        return offset + arg.length();
    }

    public IDocument getEditorToDocument(AbstractTextEditor editor) {
        if (editor == null) {
            EE2EDebug.printf(3, "not cont!!");
            return null;
        }
        if (editor.getDocumentProvider() == null) {
            EE2EDebug.printf(3, "not getDocumentProvider()!!");
            return null;
        }
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        return document;
    }

    protected URL getBaseURL(AbstractUIPlugin plugin) throws MalformedURLException {
        URL base;
        if (plugin != null) {
            EE2EDebug.printf(3, "use default");
            base = plugin.getDescriptor().getInstallURL();
        } else {
            EE2EDebug.printf(3, "use resouce");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.sourceforge.projects.ee2e.core.relax.EE2REe2e");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            base = clazz.getResource("../../../../../../../");
            base = new URL(base, "../../jp.sourceforge.projects.ee2e.core/");
        }
        return base;
    }

    /*
     * Unable to fully structure code
     */
    public EE2REe2e getEe2e(String arg) {
        block47: {
            if (this.getEe2eMap() == null || this.getEe2eMap().equals("")) {
                EE2EDebug.printf(3, "arg is null");
                return null;
            }
            ee2e = (EE2REe2e)this.getEe2eMap().get(arg);
            if (ee2e != null) {
                return ee2e;
            }
            try {
                plugin = EE2EPlugin.getDefault();
                base = this.getBaseURL(plugin);
                url = new URL(base, "useree2e/" + arg + ".ee2e");
                try {
                    EE2EDebug.printf(3, "url(user)=" + url.toString());
                    ee2e = new EE2REe2e(url);
                    break block47;
                }
                catch (IOException userException) {
                    EE2EDebug.printf(3, "IOException(user) e=" + userException.getMessage());
                    url = new URL(base, "lib/" + arg + ".ee2e");
                    try {
                        EE2EDebug.printf(3, "url(system)=" + url.toString());
                        ee2e = new EE2REe2e(url);
                        break block47;
                    }
                    catch (IOException myException) {
                        EE2EDebug.printf(3, "IOException(system) e=" + myException.getMessage());
                        if (plugin == null) {
                            EE2EDebug.printf(1, "plugin null!");
                            return null;
                        }
                        iDescriptor = plugin.getDescriptor();
                        if (!(iDescriptor instanceof PluginDescriptorModel)) {
                            EE2EDebug.printf(1, "iDescriptor not plugin!");
                            return null;
                        }
                        descriptor = (PluginDescriptorModel)iDescriptor;
                        model = descriptor.getFragments();
                        i = 0;
                        ** while (i < model.length && ee2e == null)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    str = model[i].getLocation();
                    base = new URL(str);
                    url = new URL(base, "lib/" + arg + ".ee2e");
                    EE2EDebug.printf(3, "file=" + base.getFile().toString());
                    try {
                        ee2e = new EE2REe2e(url);
                    }
                    catch (IOException e2) {
                        EE2EDebug.printf(3, "IOException e2=" + e2.getMessage());
                    }
                    ++i;
                    continue;
                }
lbl46:
                // 1 sources

                if (ee2e == null) {
                    EE2EDebug.printf(1, "no file in all pugin");
                    return null;
                }
            }
            catch (MalformedURLException e) {
                EE2EDebug.printf(1, "MalformedURLException e=" + e.getMessage());
                return null;
            }
            catch (SAXException e) {
                EE2EDebug.printf(1, "SAXException e=" + e.getMessage());
                return null;
            }
            catch (ParserConfigurationException e) {
                EE2EDebug.printf(1, "ParserConfigurationException e=" + e.getMessage());
                return null;
            }
        }
        this.getEe2eMap().put(arg, ee2e);
        i = 0;
        while (i < ee2e.getRequireCount()) {
            this.getEe2e(ee2e.getRequire(i).getHref());
            ++i;
        }
        i = 0;
        while (i < ee2e.getDefvarCount()) {
            defvar = ee2e.getDefvar(i);
            EE2EDebug.printf(5, "push defvar=" + defvar.getId() + " / " + ee2e.getDefvar(i));
            this.getDefvarMap().put(defvar.getId(), ee2e.getDefvar(i));
            ++i;
        }
        i = 0;
        while (i < ee2e.getDefvarCount()) {
            defvar = ee2e.getDefvar(i);
            EE2EDebug.printf(5, "defvar " + i + "/" + ee2e.getDefvarCount() + " id=" + defvar.getId());
            list = new LinkedList<IEE2RDefvarChoice>();
            j = 0;
            while (j < defvar.getContentCount()) {
                choice = defvar.getContent(j);
                if (choice instanceof EE2RAttribute) {
                    attr = (EE2RAttribute)choice;
                    if (attr.getRef() != null && !attr.getRef().equals("")) {
                        list.add(this.getAttribute(attr.getRef()));
                    } else {
                        list.add(attr);
                    }
                } else if (choice instanceof EE2REnumeration) {
                    enum = (EE2REnumeration)choice;
                    if (enum.getRef() != null && !enum.getRef().equals("")) {
                        nextdef = this.getDefvar(enum.getRef());
                        if (nextdef != null) {
                            list.addAll(this.getEnumerationSet(nextdef));
                        } else {
                            list.add(enum);
                        }
                    } else {
                        list.add(enum);
                    }
                } else if (choice instanceof EE2RTag) {
                    tag = (EE2RTag)choice;
                    if (tag.getRef() != null && !tag.getRef().equals("")) {
                        nextdef = this.getDefvar(tag.getRef());
                        if (nextdef == null) {
                            EE2EDebug.printf(1, "nextref not fount=" + tag.getRef());
                            return null;
                        }
                        k = 0;
                        while (k < nextdef.getContentCount()) {
                            if (nextdef.getContent(k) instanceof EE2RTag) {
                                nextTag = (EE2RTag)nextdef.getContent(k);
                                if (nextTag.getRef() != null) {
                                    EE2EDebug.printf(1, "tagref found!!");
                                    return null;
                                }
                            } else {
                                EE2EDebug.printf(1, "not tagref!!");
                                return null;
                            }
                            list.add(nextTag);
                            ++k;
                        }
                    } else {
                        list.add(tag);
                    }
                } else {
                    EE2EDebug.printf(1, "choice not found!!");
                    return null;
                }
                ++j;
            }
            defvar.setContent(list.toArray(new IEE2RDefvarChoice[0]));
            ++i;
        }
        iteList = ee2e.getIterationList();
        if (iteList != null) {
            col = new LinkedList<EE2RIteration>();
            i = 0;
            while (i < iteList.getIterationCount()) {
                ite = iteList.getIteration(i);
                if (ite.getRequire() != null && !ite.getRequire().equals("")) {
                    requireEe2e = this.getEe2e(ite.getRequire());
                    if (requireEe2e == null) {
                        EE2EDebug.printf(1, "requireEe2e not found!!");
                        return null;
                    }
                    requireIteList = requireEe2e.getIterationList();
                    if (requireIteList == null) {
                        EE2EDebug.printf(1, "requireIteList not found!!");
                        return null;
                    }
                    j = 0;
                    while (j < requireIteList.getIterationCount()) {
                        iteSingle = requireIteList.getIteration(j);
                        if (iteSingle.getOpener() != null && !iteSingle.getOpener().equals("")) {
                            col.add(iteSingle);
                        }
                        ++j;
                    }
                } else {
                    col.add(ite);
                }
                ++i;
            }
            iteList.setIteration(col.toArray(new EE2RIteration[0]));
        }
        EE2EDebug.printf(5, "getEe2e end");
        return ee2e;
    }

    public EE2RStructureList getStructureList(EE2REe2e ee2e, String select) {
        if (ee2e == null || select == null) {
            return null;
        }
        int i = 0;
        while (i < ee2e.getStructureListCount()) {
            EE2RStructureList str = ee2e.getStructureList(i);
            if (str != null && str.getType() != null && str.getType().equals(select)) {
                return str;
            }
            ++i;
        }
        return null;
    }

    public EE2RDefvar getDefvar(EE2RStructureList list) {
        if (list == null) {
            return null;
        }
        return (EE2RDefvar)this.getDefvarMap().get(list.getTagref());
    }

    public EE2RDefvar getDefvar(String ref) {
        if (ref == null) {
            return null;
        }
        return (EE2RDefvar)this.getDefvarMap().get(ref);
    }

    public EE2RTag getTag(EE2RDefvar defvar, String tagName) {
        if (defvar == null) {
            EE2EDebug.printf(3, "defvar not found");
            return null;
        }
        int i = 0;
        while (i < defvar.getContentCount()) {
            EE2RTag tag;
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2RTag && (tag = (EE2RTag)choice).getName() != null && tag.getName().equals(tagName)) {
                return tag;
            }
            ++i;
        }
        return null;
    }

    public Collection getTagSet(EE2RDefvar defvar) {
        if (defvar == null) {
            EE2EDebug.printf(3, "defvar not found");
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < defvar.getContentCount()) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2RTag) {
                EE2RTag tag = (EE2RTag)choice;
                if (tag.getName() == null) {
                    EE2EDebug.printf(1, "tagFailer id=" + defvar.getId());
                } else {
                    set.add(tag.getName());
                }
            }
            ++i;
        }
        return set;
    }

    public Collection getEnumerationSet(EE2RDefvar defvar) {
        if (defvar == null) {
            EE2EDebug.printf(3, "defvar not found");
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < defvar.getContentCount()) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2RTag) {
                EE2RTag tag = (EE2RTag)choice;
                set.add(tag.getName());
            }
            ++i;
        }
        return set;
    }

    public EE2RAttribute getAttribute(EE2RTag tag, int index) {
        if (tag == null || index < 0 || tag.getAttributeCount() <= index) {
            EE2EDebug.printf(3, "imput error");
            return null;
        }
        EE2RAttribute attribute = tag.getAttribute(index);
        if (attribute.getRef() != null && !attribute.getRef().equals("")) {
            attribute = this.getAttribute(attribute.getRef());
        }
        return attribute;
    }

    public EE2RAttribute getAttribute(String id) {
        EE2RDefvar defvar = this.getDefvar(id);
        if (defvar == null) {
            EE2EDebug.printf(3, "defvar not found");
            return null;
        }
        if (1 != defvar.getContentCount()) {
            EE2EDebug.printf(3, "not choice");
            return null;
        }
        IEE2RDefvarChoice choice = defvar.getContent(0);
        if (!(choice instanceof EE2RAttribute)) {
            EE2EDebug.printf(3, "instanceof error");
            return null;
        }
        return (EE2RAttribute)choice;
    }

    public String replaceFileSeparator(String input) {
        StringBuffer buff = new StringBuffer(input);
        int j = 0;
        while (j < buff.length()) {
            if (buff.charAt(j) == '\\') {
                buff.setCharAt(j, '/');
            }
            ++j;
        }
        return buff.toString();
    }

    public Map getEe2eMap() {
        return this.ee2eMap;
    }

    protected Map getDefvarMap() {
        return this.defvarMap;
    }

    public void clearEe2eMap() {
        this.getEe2eMap().clear();
        this.getDefvarMap().clear();
    }
}

