package jp.sourceforge.projects.ee2e.core;
import org.eclipse.ui.*;
import org.eclipse.jface.preference.*;

import jp.sourceforge.projects.ee2e.core.scratch.EE2EMessageView;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public final class EE2EDebug {
    /**
     * this is constractor
     */
    public EE2EDebug() {
    }
    /**
     * @param nowLevel
     * @param str
     */
    public static void printf(int nowLevel, String str) {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        int level;
        if (plugin != null) {
            IPreferenceStore store = plugin.getPreferenceStore();
            level = store.getInt(EE2EPlugin.P_DEBUG_LEVEL);
        } else {
            level = Integer.MAX_VALUE;
        }
        if (level < nowLevel) {
            return;
        }
        if (nowLevel <= 1) {
            System.err.println(str);
        } else {
            System.out.println(str);
        }
        EE2EDebug.sendMessageView(str);
    }
    protected static void sendMessageView(String str) {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IWorkbench bentch = plugin.getWorkbench();
        if (bentch == null) {
            return;
        }
        IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IViewPart part = page.findView(EE2EPlugin.MESSAGE_VIEW_ID);
        if (part == null) {
            return;
        }
        if (!(part instanceof EE2EMessageView)) {
            return;
        }
        EE2EMessageView message = (EE2EMessageView) part;
        message.append(str);
        message.append("\n");
    }
}
