package jp.sourceforge.projects.ee2e.core.display;
/**
* To change this generated comment edit the template variable "typecomment":
* Window&gt;Preferences&gt;Java&gt;Templates.
* To enable and disable the creation of type comments go to
* Window&gt;Preferences&gt;Java&gt;Code Generation.
*
* @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
*/
public interface EE2EDisplayCompletion {
    /** The message which stimulates an input is returned.
     * @return The message which stimulates an input is returned.
     */
    String getTitleText();
    
    /** Attribute list is returned.
     * @return Attribute list.
     */
    java.util.Collection getTagList();

    /** The processing number in a attribute list is returned.
     * @return The processing number in a attribute list.
     */
    String getTagListSelect();
  
    /** A complement list is returned from inputted string.
     * @param string The value of mini buffer.
     * @return A complement list is returned from inputted string.
     */ 
    java.util.Collection allCompletions(String string);

    /**
     * Behavior when return key is pushed is described.
     * @param string The character string which matched
     */
    void returnAction(String string);
    
    /**
     * Behavior when closing a window.
     */
    void dispose(); 
}
