package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;


import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.ui.IEditorPart;
import org.eclipse.jface.action.IMenuManager;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView;

import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IEditorSite;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.model.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ETextEditorActionContributor
    extends BasicTextEditorActionContributor {
    public EE2ETextEditorActionContributor() {
        super();
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor start!");
    }

    /**
     * @see org.eclipse.ui.IEditorActionBarContributor#setActiveEditor(IEditorPart)
     */
    public void setActiveEditor(IEditorPart part) {
        EE2ETextEditorActionContributor.checkSetting(part);
        EE2ETextEditorActionContributor.createIMenuManager(part);
        super.setActiveEditor(part);
    }
    /**
     * @see IEditorActionBarContributor#dispose()
     * @since 2.0
     */
    public void dispose() {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor#dispose");
        EE2EMiniBufferView.removeEE2EDisplayCompletion();
        super.dispose();
    }
    /**
     * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToMenu(IMenuManager)
     */
    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        staticContributeToMenu(iMenuManager);
    }

    /**
     * Method checkSetting.
     * @param part
     */
    public static final synchronized void checkSetting(IEditorPart part) {
        EE2EDebug.printf(4, "EE2ETextEditorActionContributor#checkSetting");
        EE2ETextEditorActionContributor.changeScopeStatus(part);
        IPreferenceStore iStore = EE2EPlugin.getDefault().getPreferenceStore();
        if ((iStore.getInt(EE2EPlugin.P_SET_FLAG) == 0)
            || (iStore.getString(EE2EPlugin.P_CONTRY) == null)
            || iStore.getString(EE2EPlugin.P_CONTRY).equals("")
            || (iStore.getString(EE2EPlugin.P_LOCALE) == null)
            || iStore.getString(EE2EPlugin.P_LOCALE).equals("")) {
            EE2EPlugin.getDefault().initializeDefaults();
        }
    }
    /**
     * Method createIMenuManager.
     * @param part
     */
    public static final synchronized void createIMenuManager(IEditorPart part) {
        EE2EDebug.printf(
            3,
            "EE2ETextEditorActionContributor#createIMenuManager");
        if (getCManager() == null) {
            setCManager(new EE2ECreateIMenuManager());
            getCManager().overWriteManager(manager);
        }
        getCManager().setActivePart((AbstractTextEditor) part);
    }
    /** */
    public static final void staticContributeToMenu(IMenuManager myManager) {
        EE2EDebug.printf(3, "EE2ETextEditorActionContributor#contributeToMenu");
        manager = myManager;
        if (getCManager() == null) {
            setCManager(new EE2ECreateIMenuManager());
        }
        getCManager().overWriteManager(manager);
    }
    /** set scope */
    public static void changeScopeStatus(IEditorPart part) {
        EE2EDebug.printf(
            3,
            "EE2ETextEditorActionContributor#changeScopeStatus");
        if (part == null) {
            return;
        }
        IEditorSite editorSite = part.getEditorSite();
        if (editorSite == null) {
            return;
        }
        IKeyBindingService servise =
            part.getEditorSite().getKeyBindingService();
        if (servise == null) {
            return;
        }
        String[] scopes = servise.getScopes();
        if ((scopes.length == 1) && scopes[0].equals(TEXT_EDITOR_SCOPE)) {
            scopes[0] = EE2E_TEXT_SCOPE;
            servise.setScopes(scopes);
        } else if (
            (scopes.length == 1) && scopes[0].equals(JAVA_EDITOR_SCOPE)) {
            scopes[0] = EE2E_JAVA_SCOPE;
            servise.setScopes(scopes);
        } else if (
            (scopes.length == 1) && (scopes[0].equals(CDT_EDITOR_SCOPE))) {
            if(isEe2eCdt()) {
                scopes[0] = EE2E_CDT_SCOPE;
                servise.setScopes(scopes);                
            } else {
                EE2EDebug.printf(1, "EE2E CDT not install!!");
            }
        } else if (
            (scopes.length == 1)
                && (scopes[0].equals(EE2E_TEXT_SCOPE)
                    || scopes[0].equals(EE2E_JAVA_SCOPE))) {
            /*EE2EDebug.printf(10, "scope aready setted.");*/
        } else {
            EE2EDebug.printf(1, "Error unknown scope!!");
            for (int i = 0; i < scopes.length; i++) {
                EE2EDebug.printf(5, "\tscope[" + i + "]= " + scopes[i]);
            }
        }
    }

    public static boolean isEe2eCdt() {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return false;
        }
        IPluginDescriptor iDescriptor = plugin.getDescriptor();
        if(! (iDescriptor instanceof PluginDescriptorModel)) {
            EE2EDebug.printf(1, "iDescriptor not plugin!");
            return false;
        }
        PluginDescriptorModel descriptor = (PluginDescriptorModel) iDescriptor;
        PluginFragmentModel[] model = descriptor.getFragments();
        for (int i = 0 ; i < model.length ; i++) {
            String id = model[i].getId();
            if (id.equals(EE2E_CDT_FLAGMENT_ID)) {
                return true;
            }
        }
        return false;
    }

    protected static final String TEXT_EDITOR_SCOPE =
        "org.eclipse.ui.textEditorScope";
    protected static final String JAVA_EDITOR_SCOPE =
        "org.eclipse.jdt.ui.javaEditorScope";
    protected static final String CDT_EDITOR_SCOPE =
        "org.eclipse.cdt.ui.cEditorScope";
    protected static final String EE2E_TEXT_SCOPE =
        "jp.sourceforge.projects.ee2e.core.textEditorScope";
    protected static final String EE2E_JAVA_SCOPE =
        "jp.sourceforge.projects.ee2e.core.javaEditorScope";
    protected static final String EE2E_CDT_SCOPE =
        "jp.sourceforge.projects.ee2e.core.cdtEditorScope";
    protected static final String EE2E_CDT_FLAGMENT_ID =
        "jp.sourceforge.projects.ee2e.core.cdt";
        
    /** getter */
    public static final EE2ECreateIMenuManager getCManager() {
        return cManager;
    }
    /** setter */
    public static final void setCManager(EE2ECreateIMenuManager myManager) {
        cManager = myManager;
    }
    private static IMenuManager manager;
    private static EE2ECreateIMenuManager cManager;
}
