package jp.sourceforge.projects.ee2e.core.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class EE2EPreferencePage
    extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {

    public EE2EPreferencePage() {
        super(GRID);
        EE2EDebug.printf(3, "EE2EPreferencePage#EE2EPreferencePage()");
        EE2EPlugin.getDefault().initializeDefaults();
        this.setPreferenceStore(EE2EPlugin.getDefault().getPreferenceStore());
        this.setDescription(EE2EPlugin.getResourceString(EE2EPlugin.P_MENU));
    }

    /**
        * Creates the field editors. Field editors are abstractions of
        * the common GUI blocks needed to manipulate various types
        * of preferences. Each field editor knows how to save and
        * restore itself.
        */
    public void createFieldEditors() {
        EE2EDebug.printf(3, "EE2EPreferencePage#createFieldEditors()");
        this.addField(
            new IntegerFieldEditor(
                EE2EPlugin.P_DEBUG_LEVEL,
                EE2EPlugin.getResourceString(EE2EPlugin.P_DEBUG_LEVEL),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_URL_JUMP_HOST,
                EE2EPlugin.getResourceString(EE2EPlugin.P_URL_JUMP_HOST),
                getFieldEditorParent()));
        this.addField(
            new IntegerFieldEditor(
                EE2EPlugin.P_URL_JUMP_NUMBER,
                EE2EPlugin.getResourceString(EE2EPlugin.P_URL_JUMP_NUMBER),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_CONTRY,
                EE2EPlugin.getResourceString(EE2EPlugin.P_CONTRY_LABEL),
                getFieldEditorParent()));
        this.addField(
            new StringFieldEditor(
                EE2EPlugin.P_LOCALE,
                EE2EPlugin.getResourceString(EE2EPlugin.P_LOCALE_LABEL),
                getFieldEditorParent()));
        this.addField(
            new BooleanFieldEditor(
                EE2EPlugin.P_COMPACT_INDENT,
                EE2EPlugin.getResourceString(EE2EPlugin.P_COMPACT_INDENT),
                getFieldEditorParent()));
        this.addField(
            new BooleanFieldEditor(
                EE2EPlugin.P_ENGLISH,
                EE2EPlugin.getResourceString(EE2EPlugin.P_ENGLISH),
                getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        EE2EDebug.printf(3, "EE2EPreferencePage#init()");
    }
}