package jp.sourceforge.projects.ee2e.core.scratch;
import java.net.MalformedURLException;

import jp.sourceforge.projects.ee2e.core.*;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.*;
import org.eclipse.ui.*;
import org.eclipse.swt.SWT;

import org.eclipse.swt.widgets.Text;
import org.eclipse.jface.action.*;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ide.IDE;

/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class EE2EScratchView extends ViewPart {
	/**
	 * Creates a content outline view with no content outline pages.
	 */
	public EE2EScratchView() {
		super();
	}
	public void setFocus() {
		this.text.setFocus();
	}
	public String getSelectionText() {
		String selection = this.text.getSelectionText();
		return selection;
	}

	public void createPartControl(Composite parent) {
		this.setTitle(this.getScratchTitle());
		this.text = new Text(parent, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		//
		Action clearAction =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_DELETE)) {
			public void run() {
				deleteAll();
			}
		};
        ImageDescriptor image;
        try {
            java.net.URL prefix = new java.net.URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL(new java.net.URL(prefix, "ee2eerase.gif"));
        } catch (MalformedURLException e) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                ISharedImages.IMG_OBJS_WARN_TSK);
        }
		clearAction.setImageDescriptor(image);
		//
		//
		Action fileJump =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_EDITOR)) {
			public void run() {
				EE2EFileJumpAction action = new EE2EFileJumpAction();
                action.init(EE2EScratchView.this);
                action.run(this);
			}
		};
        try {
            java.net.URL prefix = new java.net.URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL(new java.net.URL(prefix, "ee2e.gif"));
        } catch (MalformedURLException e) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                ISharedImages.IMG_OBJ_FILE);
        }
        fileJump.setImageDescriptor(image);
        fileJump.setToolTipText(EE2EPlugin.getResourceString("action.filejump.tooltip"));
        //
        Action fileSystemJump =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_SYSTEM)) {
			public void run() {
				EE2EFileSystemJumpAction action = new EE2EFileSystemJumpAction();
                action.init(EE2EScratchView.this);
                action.run(this);
			}
		};
        try {
            java.net.URL prefix = new java.net.URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL(new java.net.URL(prefix, "ee2esystem.gif"));
        } catch (MalformedURLException e) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK);
        }
		fileSystemJump.setImageDescriptor(image);
        fileSystemJump.setToolTipText(EE2EPlugin.getResourceString("action.filejump.system.tooltip"));
		//
		//
		IActionBars bars = getViewSite().getActionBars();
		IMenuManager manager = bars.getMenuManager();
		//
		IToolBarManager toolBarManager =
			getViewSite().getActionBars().getToolBarManager();
		//
		toolBarManager.add(fileJump);
		manager.add(fileJump);
		toolBarManager.add(fileSystemJump);
		manager.add(fileSystemJump);
		toolBarManager.add(clearAction);
		manager.add(clearAction);
	}
	protected java.io.File getParent() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if(workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = 
        workbench.getActiveWorkbenchWindow();
        if(workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = 
        workbenchWindow.getActivePage();
        if(workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        if(editorPart == null) {
            return null;
        }
        IEditorInput editorInput = editorPart.getEditorInput();
        if(editorInput == null) {
            return null;
        }
        if(!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput) editorInput;
        IFile file = fileEditorInput.getFile();
        if(file == null) {
            return null;
        }
        IPath path = file.getLocation();
        if(path == null) {
            return null;
        }
		return path.toFile();
	}
	protected String getScratchTitle() {
		return "*scratch*";
	}
	public void append(String string) {
		this.text.append(string);
	}
	public void deleteAll() {
		this.text.setText("");
	}
    public void setOffset(int start,int end) {
        if (start < end) {
            this.text.setSelection(start,end);
        } else {
            this.text.setSelection(start);
        }
    }
	protected Text getText() {
		return this.text;
	}
	private Text text;
}