/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.io.File;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentCppFormat;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentSnmpFormat;

class CICheckExtention {
    public static final String NONE_MODE = "none  ";
    public static final String C_MODE = "c     ";
    public static final String JAVA_MODE = "java  ";
    public static final String SNMP_MODE = "snmp  ";

    public String getType(File file) {
        String fileName = file.getAbsolutePath().toString();
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc < 0) {
            return NONE_MODE;
        }
        String ext = fileName.substring(dotLoc + 1);
        if (ext.equalsIgnoreCase("java")) {
            return JAVA_MODE;
        }
        if (ext.equalsIgnoreCase("ih") || ext.equalsIgnoreCase("hh") || ext.equalsIgnoreCase("ic") || ext.equalsIgnoreCase("c") || ext.equalsIgnoreCase("cc") || ext.equalsIgnoreCase("cpp") || ext.equalsIgnoreCase("cxx") || ext.equalsIgnoreCase("h")) {
            return C_MODE;
        }
        if (ext.equalsIgnoreCase("mib")) {
            return SNMP_MODE;
        }
        return NONE_MODE;
    }

    public EE2EIndentAction getEE2EIndentAction(File file) {
        String type = this.getType(file);
        if (type.equals(C_MODE)) {
            return new EE2EIndentCppFormat(4, false);
        }
        if (type.equals(JAVA_MODE)) {
            return new EE2EIndentCppFormat(4, false);
        }
        if (type.equals(SNMP_MODE)) {
            return new EE2EIndentSnmpFormat(4);
        }
        return null;
    }
}

