/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.io.File;
import jp.sourceforge.projects.ee2e.core.indent.*;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Extention check
 */
class CICheckExtention {
    public static final String NONE_MODE = "none  ";

    public static final String C_MODE = "c     ";

    public static final String JAVA_MODE = "java  ";

    public static final String SNMP_MODE = "snmp  ";

    public CICheckExtention() {
    }

    public String getType(File file) {
        String fileName = file.getAbsolutePath().toString();
        int dotLoc = fileName.lastIndexOf('.');
        String ext;
        if (0 <= dotLoc) {
            ext = fileName.substring(dotLoc + 1);
        } else {
            return NONE_MODE;
        }
        if (ext.equalsIgnoreCase("java")) {
            return JAVA_MODE;
        }
        //if (ext.equalsIgnoreCase("jsp")) {
        //    return JSP_MODE;
        //}
        if (ext.equalsIgnoreCase("ih")
            || ext.equalsIgnoreCase("hh") || ext.equalsIgnoreCase("ic")
            || ext.equalsIgnoreCase("c") || ext.equalsIgnoreCase("cc")
            || ext.equalsIgnoreCase("cpp") || ext.equalsIgnoreCase("cxx")
            || ext.equalsIgnoreCase("h")) {
            return C_MODE;
        }
        //if (ext.equalsIgnoreCase("xi") || ext.equalsIgnoreCase("xhtml")
        //    || ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("xhtm")
        //    || ext.equalsIgnoreCase("htm") || ext.equalsIgnoreCase("jsp")
        //    || ext.equalsIgnoreCase("jspf") || ext.equalsIgnoreCase("rlx")
        //    || ext.equalsIgnoreCase("rxm") || ext.equalsIgnoreCase("rxg")
        //    || ext.equalsIgnoreCase("sdoc") || ext.equalsIgnoreCase("ee2e")
        //    || ext.equalsIgnoreCase("xsl") || ext.equalsIgnoreCase("xsd")
        //    || ext.equalsIgnoreCase("xslt") || ext.equalsIgnoreCase("jnlp")
        //    || ext.equalsIgnoreCase("xjnlp") || ext.equalsIgnoreCase("xml")
        //    || ext.equalsIgnoreCase("tld") || ext.equalsIgnoreCase("bml")
        //    || ext.equalsIgnoreCase("diejaxaco")) {
        //    return XML_MODE;
        //}
        if (ext.equalsIgnoreCase("mib")) {
            return SNMP_MODE;
        }
        //if (ext.equalsIgnoreCase("el")) {
        //    return E_LISP_MODE;
        //}
        return NONE_MODE;
    }
    public EE2EIndentAction getEE2EIndentAction(File file) {
        String type = getType(file);
        if (type.equals(C_MODE)) {
            return new EE2EIndentCppFormat(4,false);
        } else if (type.equals(JAVA_MODE)) {
            return new EE2EIndentCppFormat(4,false);
        } else if (type.equals(SNMP_MODE)) {
            return new EE2EIndentSnmpFormat(4);
        }
        return null;
    }
}