/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextArea;

import jp.sourceforge.projects.ee2e.core.indent.*;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Execute action
 */
class CIExecuteAction implements Runnable {
    public CIExecuteAction(JTextArea area) {
        this.area = area;
    }
    private JTextArea area;
    public void run() {
        CIPlugin plugin = CIPlugin.getDefault();
        List list = plugin.getProfile().getFileList();
        if (list != null) {
            CICheckExtention extention = new CICheckExtention();
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                File file = (File) ite.next();
                file = file.getAbsoluteFile();
                this.doSingleAction(file);
            }
        }
        this.area.append("end\n");
        this.area.append("\n");
        this.area.append("Please hit close button.\n");
        this.area.append("\n");
    }
    public void doSingleAction(File file) {
        this.area.append("Action. " + file + "\n");
        File backup = this.doBackup(file);
        File outputFile = file;
        String work = this.readFile(file);
        work = this.doSharpAction(file,work);
        work = this.doMiniFormat(file,work);
        work = this.doIndent(file,work);
        this.doOutputAction(outputFile,work);
    }
    public File doBackup(File file) {
        this.area.append("\tBack up Action. " + file + "\n");
        File target = new File(file.toString() + ".old");
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(file);
            outStream = new FileOutputStream(target);
            while (true) {
                int ans = inStream.read();
                if (ans < 0) {
                    break;
                }
                outStream.write(ans);
            }
        } catch (FileNotFoundException e) {
            //EMPTY
        } catch (IOException e) {
            //EMPTY
        }
        try {
            if (inStream != null) {
                inStream.close();
            }
        } catch (IOException e1) {
            //EMPTY
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        } catch (IOException e2) {
            //EMPTY
        }
        return target;
    }
    protected String readFile(File inFile) {
        this.area.append("\tRead file action. " + inFile.toString() + "\n");
        FileInputStream fileStream = null;
        Reader sReader = null;
        BufferedReader bReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            fileStream = new FileInputStream(inFile);
            sReader = new InputStreamReader(fileStream);
            bReader =
                new java.io.BufferedReader(sReader);
            while (true) {
                String ans = bReader.readLine();
                if (ans == null) {
                    break;
                }
                buffer.append(ans);
                buffer.append("\n");
            }
        } catch (IOException e1) {
            //EMPTY
        }
        try {
            if (bReader != null) {
                bReader.close();
                sReader = null;
                fileStream = null;
            }
        } catch (IOException e1) {
            //EMPTY
        }
        try {
            if (sReader != null) {
                sReader.close();
                fileStream = null;
            }
        } catch (IOException e1) {
            //EMPTY
        }
        try {            
            if (fileStream != null) {
                fileStream.close();
            }
        } catch (IOException e1) {
            //EMPTY
        }     
        return buffer.toString();  
    }
    protected String doSharpAction(File inFile,String targetString) {
        CICheckExtention extention = new CICheckExtention();
        if (!extention.getType(inFile).equals(CICheckExtention.C_MODE)) {
            return targetString;
        }
        this.area.append("\tIfdef/ifndef delete action.\n");
        
        Reader sReader = null;
        BufferedReader bReader = null;
        CIPlugin plugin = CIPlugin.getDefault();        
        CIIfdefData [] data = plugin.getProfile().getIfdefList();     
        try {
            for (int i = 0 ; i < data.length ; i++) {
                if (!data[i].isIfdefExecute()) {
                    continue;
                }
                sReader = new StringReader(targetString);
                bReader = new BufferedReader(sReader);
                EE2ECppSharp sharp = new EE2ECppSharp("");
                sharp.createComposit(bReader);
                bReader.close();
                sharp.destoryTarget(data[i].getKey(), data[i].ifdefOrIfndef());
                java.io.StringWriter sWriter = new java.io.StringWriter();
                sharp.getWriter(sWriter, false);
                targetString = sWriter.toString();
                sWriter.close();
            }
        } catch (IOException e) {
            //EMPTY
        }
        return targetString;
    }
    protected String doMiniFormat(File inFile,String targetString) {
        CICheckExtention extention = new CICheckExtention();
        if (!extention.getType(inFile).equals(CICheckExtention.C_MODE)) {
            return targetString;
        }
        this.area.append("\tMini format action.\n");
        EE2ECppMiniFormatBehavior behavior = new EE2ECppMiniFormatBehavior();
        String lastWord = targetString;
        try {
            lastWord = behavior.doBehavior(targetString);
        } catch (IOException e) {
            this.area.append("\tIOException e=" + e.getMessage() + "\n");
        }
        return lastWord;
    }
    protected String doIndent(File inFile,String targetString) {
        CICheckExtention extention = new CICheckExtention();
        EE2EIndentAction action = extention.getEE2EIndentAction(inFile);
        this.area.append("\tIfdef/ifndef delete action.\n");
        EE2EDocument document = new EE2ECIDocument(targetString);
        try {
            action.doIndent(0,document);
        } catch (EE2EIndentException e) {
            return targetString;
        }
        return document.get();
    }
    protected void doOutputAction(File outFile,String targetString) {
        this.area.append("\tFile output action." + outFile.toString() + "\n");
        FileOutputStream oStream = null;
        OutputStreamWriter oWriter = null;
        try {
            oStream = new FileOutputStream(outFile);
            oWriter = new OutputStreamWriter(oStream);
            oWriter.write(targetString);
        } catch (IOException e2) {
            //EMTYP
        }
        try {
            if (oWriter != null) {
                oWriter.close();
                oStream = null;
            }
        } catch (IOException e2) {
            //EMTYP
        }
        try {
            if (oStream != null) {
                oStream.close();
            }
        } catch (IOException e2) {
            //EMTYP
        }
    }
}
