/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;
import java.io.File;
import java.util.Iterator;
import java.util.List;

import javax.swing.*;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Execute action
 */
class CIExecutePanel implements CINextPanel {
    public static final String TITLE = "execute.title";

    public CIExecutePanel() {
    }
    public JComponent createComponent() {
        this.text = new JTextArea();
        JScrollPane bar = new JScrollPane(this.text); 
        return bar;
    }
    public String firstAction() {
        CIPlugin plugin = CIPlugin.getDefault();
        text.append(plugin.getString(CIFolderPanel.TITLE));
        text.append("\n");
        text.append(plugin.getProfile().getFile().getAbsoluteFile().toString());
        text.append("\n");
        List list = plugin.getProfile().getFileList();
        if (list != null) {
            CICheckExtention extention = new CICheckExtention();
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                File file = (File) ite.next();
                text.append(extention.getType(file));
                text.append(" ");
                text.append(file.getAbsoluteFile().toString());
                text.append("\n");
            }
        }
        text.append("\n");
        text.append(plugin.getString(CIIfdefPanel.TITLE));
        text.append("\n");
        CIIfdefData [] data = plugin.getProfile().getIfdefList();
        for (int i = 0 ; i < data.length ; i++) {
            if (data[i].isIfdefExecute()) {
                text.append(data[i].getKey());
                text.append("  ");
                if (data[i].ifdefOrIfndef()) {
                    text.append("ifdef delete");
                } else {
                    text.append("if N def delete");
                }
                text.append("\n");
            }   
        }
        text.append("\n");
        text.append(plugin.getString(TITLE));
        text.append("\n");
        return TITLE;
    }
    public void nextAction() {
        //
        CIExecuteAction action = new CIExecuteAction(this.text);
        Thread thread = new Thread(action);
        thread.start();
    }
    public boolean isNextOk() {
        return true;
    }
    public boolean isLast() {
        return true;
    }
    private JTextArea text;
}
