/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import javax.swing.*;
import java.awt.event.*;
import java.io.File;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Folder selection
 */
class CIFolderPanel implements CINextPanel {
    public static final String TITLE = "folder.title";

    public CIFolderPanel() {
    }

    public JComponent createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new java.awt.GridLayout(5, 1));
        this.text = new JTextField(CIPlugin.getDefault().getProfile().getFile()
                .toString());
        this.panel.add(this.text);
        JButton button = new JButton(CIPlugin.getDefault().getString(TITLE));
        this.panel.add(button);
        button.addActionListener(this.actionListener);
        return this.panel;
    }

    private ActionListener actionListener = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            File file = new File(CIFolderPanel.this.text.getText());
            if (!CIFolderPanel.this.isNextOk()) {
                file = new java.io.File(CIPlugin.getDefault().getProfile()
                        .getFile().toString());
            }
            chooser.setCurrentDirectory(file);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            int returnVal = chooser.showOpenDialog(CIFolderPanel.this.panel);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                CIFolderPanel.this.text.setText(chooser.getSelectedFile()
                        .toString());
            }
        }
    };

    public String firstAction() {
        return TITLE;
    }

    public void nextAction() {
        CIPlugin.getDefault().getProfile().setFile(
                new File(this.text.getText()));
    }

    public boolean isNextOk() {
        File file = new File(this.text.getText());
        return file.isFile() || file.isDirectory();
    }

    public boolean isLast() {
        return false;
    }

    private JTextField text;

    private JPanel panel;
}