/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.awt.CardLayout;

import javax.swing.*;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Swing Main Frame
 */
class CIFrame extends JFrame {
    public static final String CARD_HEAD = "CI";

    public static final String TITLE = "frame.top.title";

    public static final String BUTTON_NEXT = "button.next";

    public static final String BUTTON_END = "button.end";

    public CIFrame() {
        super(CIPlugin.getDefault().getString(TITLE));
        this.addWindowListener(new CIWindowClose(this));
        this.createFrame();
    }

    public void createFrame() {
        this.getContentPane().setLayout(new java.awt.BorderLayout());

        this.mainPanel = new JPanel();
        this.nextPanel = new CINextPanel[3];
        this.nextPanel[0] = new CIFolderPanel();
        this.ifPanel = new CIIfdefPanel();
        this.nextPanel[1] = ifPanel;
        this.nextPanel[2] = new CIExecutePanel();
        CardLayout cLayout = new CardLayout();
        this.mainPanel.setLayout(cLayout);
        for (int i = 0; i < this.nextPanel.length; i++) {
            this.mainPanel.add(nextPanel[i].createComponent(), CARD_HEAD + i);
        }
        this.nowPanel = 0;
        String titleKey = nextPanel[this.nowPanel].firstAction();
        titleKey = CIPlugin.getDefault().getString(titleKey);
        cLayout.show(this.mainPanel, CARD_HEAD + this.nowPanel);
        this.getContentPane().add(this.mainPanel, java.awt.BorderLayout.CENTER);

        this.nextButton = new JButton(CIPlugin.getDefault().getString(
            BUTTON_NEXT));
        this.nextButton.addActionListener(new CINextButtonActionListener());
        this.getContentPane().add(this.nextButton, java.awt.BorderLayout.SOUTH);
    }

    public void doNextAction() {
        this.nextButton.setEnabled(false);
        this.setEnabled(false);
        ((CardLayout) this.mainPanel.getLayout()).show(this.mainPanel,
                CARD_HEAD + this.nowPanel);
        if (this.nextPanel.length <= this.nowPanel) {
            return;
        }
        CINextPanel panel = this.nextPanel[this.nowPanel];
        panel.nextAction();
        if (!panel.isNextOk()) {
            return;
        }
        this.nowPanel++;
        if (this.nextPanel.length <= this.nowPanel) {
            return;
        }
        panel = this.nextPanel[this.nowPanel];
        String titleKey = panel.firstAction();
        if (panel.isLast()) {
            this.nextButton
                    .setText(CIPlugin.getDefault().getString(BUTTON_END));
        }
        ((CardLayout) this.mainPanel.getLayout()).show(this.mainPanel,
                CARD_HEAD + this.nowPanel);
        this.setEnabled(true);
        this.nextButton.setEnabled(true);
    }
    public void setTableRepaint() {
        this.ifPanel.setTableRepaint();
    }
    private int nowPanel;

    private JPanel mainPanel;

    private JButton nextButton;

    private CINextPanel[] nextPanel;
    private CIIfdefPanel ifPanel;
}