/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import javax.swing.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.Iterator;

import jp.sourceforge.projects.ee2e.core.indent.EE2ECppSharp;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Folder selection
 */
class CIIfdefAction implements Runnable {
    public CIIfdefAction() {
        this.extention = new CICheckExtention();
    }
    public void run() {
        CIPlugin plugin = CIPlugin.getDefault();
        this.setStatus(plugin.getString(CIIfdefPanel.S_FOLDER));
        java.util.ArrayList list = new java.util.ArrayList();
        java.util.TreeSet ifdefList = new java.util.TreeSet();
        this.getArrayList(list, plugin.getProfile().getFile());
        plugin.getProfile().setFileList(list);
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            File file = (File) ite.next();
            if(extention.getType(file).equals(CICheckExtention.C_MODE)) {
                this.addIfdefList(ifdefList,file);
            }
        }
        CIIfdefData [] data = new CIIfdefData[ifdefList.size()];
        ite = ifdefList.iterator();
        int i = 0;
        while (ite.hasNext()) {
            CIIfdefData target = (CIIfdefData) ite.next();
            data[i] = target;
            i++;
        }
        plugin.getProfile().setIfdefList(data);
        this.closeStatus();
        plugin.getFrame().setTableRepaint();
        return;
    }

    public void getArrayList(java.util.ArrayList list, File file) {
        CIPlugin plugin = CIPlugin.getDefault();
        this.setStatus(file.toString() + plugin.getString(CIIfdefPanel.S_FOLDER));
        if (file.isFile()) {
            if (! extention.getType(file).equals(CICheckExtention.NONE_MODE)) {
                list.add(file);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; i++) {
                this.getArrayList(list, fileList[i]);
            }
        }
    }
    public void addIfdefList(TreeSet list,File file) {
        EE2ECppSharp sharp = new EE2ECppSharp("");
        FileInputStream fileStream = null;
        InputStreamReader sReader = null;
        java.io.BufferedReader bReader = null;
        try {
            fileStream = new FileInputStream(file);
            sReader = new InputStreamReader(fileStream);
            bReader =
                new java.io.BufferedReader(sReader);
            sharp.createComposit(bReader);
        } catch (FileNotFoundException e) {
            return;
        } catch (IOException e) {
            return;
        } finally {
            try {
                if (bReader != null) {
                    bReader.close();
                } else if (sReader != null) {
                    sReader.close();
                } else if (fileStream != null) {
                    fileStream.close();
                }
            } catch (IOException e1) {
                /*NONE*/
            }
        }
        java.util.Collection collection = new java.util.TreeSet();
        sharp.getDefines(collection);
        //
        Iterator ite = collection.iterator();
        while (ite.hasNext()) {
            String string = (String) ite.next();
            list.add(new CIIfdefData(string));
        }
    }

    public void setStatus(String string) {
        if (status == null) {
            status = new CIStatusDialog(string);
        }
        status.setStatus(string); 
        status.setVisible(true);
    }
    public void closeStatus() {
        status.setVisible(false);
        status.dispose();
    }
    private CIStatusDialog status;

    private CICheckExtention extention;

    private JTable table;
}
