/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import javax.swing.*;

import java.awt.event.*;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Folder selection
 */
class CIIfdefPanel implements CINextPanel {
    public static final String TITLE = "ifdef.title";

    public static final String S_FOLDER = "ifdef.status.folder";

    public CIIfdefPanel() {
    }

    public JComponent createComponent() {
        CIIfdefTableModel model = new CIIfdefTableModel();
        this.table = new JTable(model);
        this.table.addMouseListener(actionListener);
        JScrollPane bar = new JScrollPane(this.table); 
        return bar;
    }

    public String firstAction() {
        CIIfdefAction action = new CIIfdefAction();
        //action.run();
        Thread thread = new Thread(action);
        thread.start();
        return TITLE;
    }
    public void nextAction() {
    }

    public boolean isNextOk() {
        return true;
    }

    public boolean isLast() {
        return false;
    }
    public void setTableRepaint() {
        this.table.revalidate();
        this.table.repaint();
    }
    
    public void doMouseAction() {
        int [] list = this.table.getSelectedRows();
        CIPlugin plugin = CIPlugin.getDefault();
        CIIfdefData [] data = plugin.getProfile().getIfdefList();
        for (int i = 0 ; i < list.length ; i++) {
            data[list[i]].toggle();
        }
        this.table.repaint();
    }
    private MouseListener actionListener = new MouseListener() {
        /**
         * Invoked when the mouse button has been clicked (pressed
         * and released) on a component.
         */
        public void mouseClicked(MouseEvent e) {}

        /**
         * Invoked when a mouse button has been pressed on a component.
         */
        public void mousePressed(MouseEvent e) {}

        /**
         * Invoked when a mouse button has been released on a component.
         */
        public void mouseReleased(MouseEvent e) {
            CIIfdefPanel.this.doMouseAction();
        }

        /**
         * Invoked when the mouse enters a component.
         */
        public void mouseEntered(MouseEvent e) {}

        /**
         * Invoked when the mouse exits a component.
         */
        public void mouseExited(MouseEvent e) {}
    };

    private JTable table;
}
