/*
 * Created on 2004/08/21
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.cindenter;

import java.io.File;
import java.util.ResourceBundle;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Main program
 */
public class CIPlugin {
    /**
     * constractor
     */
    public CIPlugin() {
        CIPlugin.plugin = this;
    }

    /**
     * Returns the shared instance.
     */
    public static CIPlugin getDefault() {
        return plugin;
    }

    private static CIPlugin plugin;

    /**
     * main
     * 
     * @param args
     */
    public static void main(String[] args) {
        CIPlugin cIMain = new CIPlugin();
        cIMain.createResouceBundle();
        cIMain.createProfile(args);
        cIMain.frame = new CIFrame();
        cIMain.frame.setSize(512, 256);
        cIMain.frame.setVisible(true);
    }

    /**
     * get resource bundle
     * 
     * @return resource bundle
     */
    public ResourceBundle getBundle() {
        return this.rb;
    }

    /**
     * change string for resorce bundle
     * 
     * @param key
     *            resource key
     * @return un-bundle string
     */
    public String getString(String key) {
        String ans = this.rb.getString(key);
        if (ans == null) {
            return key;
        }
        return ans;
    }

    /**
     * get main frame
     * 
     * @return main frame
     */
    public CIFrame getFrame() {
        return this.frame;
    }
    
    /**
     * get grobal data
     * @return profile
     */
    public CIProfile getProfile() {
        return this.profile;
    }
    /**
     * create bundle
     */
    protected void createResouceBundle() {
        this.rb = ResourceBundle.getBundle("CodeIndenter");
    }

    /**
     * create profile
     */
    protected void createProfile(String[] args) {
        this.profile = new CIProfile();
        if (1 <= args.length) {
            this.profile.setFile(new File(args[0]));
        } else {
            this.profile.setFile(new File("."));
        }
    }

    private ResourceBundle rb;

    private CIFrame frame;
    private CIProfile profile;
}