/*
 * Created on 2003/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.sourceforge.projects.ee2e.core.indent;

import java.io.IOException;
import java.util.*;

import junit.framework.Assert;

/**
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECppSharpTest extends EE2ECppDocumentTest {

    /**
     * Constructor for EE2ECppSharpTest.
     * @param name
     */
    public EE2ECppSharpTest(String name) {
        super(name);
    }

    /**
     * 
     */
    public void testEE2ECppSharp() {
        String target = "foo";
        EE2EMOCSharp sharp = this.createEE2ECppSharp(target);
        Assert.assertEquals(sharp.getMyString(), target);
        Assert.assertNull(sharp.getList());
        Assert.assertNull(sharp.getSharp());
    }

    /* (non-Javadoc)
     * @see jp.sourceforge.projects.ee2e.core.cdt.doc.EE2EDocumentTest#testDestoryTarget()
     */
    public void testDestoryTarget() {
        super.testDestoryTarget();
        String input;
        String target;
        String answer;
        //
        input = null;
        target = null;
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "no target\n";
        target = null;
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "no target\n";
        target = "";
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "no target\n";
        target = "hogehoge";
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = null;
        target = "hogehoge";
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "#if 0  \n";
        target = "0";
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "#if 0  \n";
        target = "no-target";
        answer = input + "#endif\n";
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "#if 0\n" + "#endif\n";
        target = "";
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "#endif\n" + "#endif\n";
        target = "0";
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        input = "#if 0\n" + "#endif\n";
        target = "no_target";
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        //
        String ifAnswer = "    aaa();\n" + "    bbb();\n" + "    ccc();\n";
        input = "#if 0\n" + ifAnswer + "#endif\n";
        target = "0";
        this.doDestoryTarget(input, target, "", true);
        this.doDestoryTarget(input, target, ifAnswer, false);
        //
        ifAnswer = "    aaa();\n" + "    bbb();\n" + "    ccc();\n";
        String elseAnswer = "    foo();\n" + "    bar();\n" + "    boo();\n";
        input = "#if 0\n" + ifAnswer + "#else\n" + elseAnswer + "#endif\n";
        target = "0";
        this.doDestoryTarget(input, target, elseAnswer, true);
        this.doDestoryTarget(input, target, ifAnswer, false);
        target = "1";
        this.doDestoryTarget(input, target, input, true);
        this.doDestoryTarget(input, target, input, false);
        //
        String prepend = "moe();\n";
        String postpend = "noe();\n";
        input =
            prepend
                + "#if 0\n"
                + ifAnswer
                + "#else\n"
                + elseAnswer
                + "#endif\n"
                + postpend;
        target = "1";
        this.doDestoryTarget(input, target, input, true);
        this.doDestoryTarget(input, target, input, false);
        target = "0";
        answer = prepend + elseAnswer + postpend;
        this.doDestoryTarget(input, target, answer, true);
        answer = prepend + ifAnswer + postpend;
        this.doDestoryTarget(input, target, answer, false);
        //
        String contain =
            prepend
                + "#if 1\n"
                + ifAnswer
                + "#else\n"
                + elseAnswer
                + "#endif\n"
                + postpend;
        input = "#if 0\n" + contain + "#endif\n";
        target = "0";
        this.doDestoryTarget(input, target, "", true);
        this.doDestoryTarget(input, target, contain, false);
        target = "1";
        answer = "#if 0\n" + prepend + elseAnswer + postpend + "#endif\n";
        this.doDestoryTarget(input, target, answer, true);
        answer = "#if 0\n" + prepend + ifAnswer + postpend + "#endif\n";
        this.doDestoryTarget(input, target, answer, false);
        //
        contain =
            ifAnswer
            + "#else\n"
            + elseAnswer
            + "#endif\n"
            + postpend;
        input =
            "#if 0\n"
                + prepend
                + "#elsif 1\n"
                + contain;
        target = "no-target";
        this.doDestoryTarget(input, target, input, true);
        this.doDestoryTarget(input, target, input, false);
        target = "0";
        answer = "#if 1\n" + contain;
        this.doDestoryTarget(input, target, answer, true);
        answer = prepend + postpend;
        this.doDestoryTarget(input, target, answer, false);
        target = "1";
        answer = "#if 0\n" + prepend + "#else\n" + elseAnswer + "#endif\n" + postpend;
        this.doDestoryTarget(input, target, answer, true);
        answer = "#if 0\n" + prepend + ifAnswer + "#endif\n" + postpend;
        this.doDestoryTarget(input, target, answer, false);
        //
        input =
            "#if 0\n"
            + prepend
            + "#if 0\n"
            + ifAnswer
            + "#else\n"
            + elseAnswer
            + "#endif\n"
            + postpend
            + "#endif\n";
        target = "0";
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
        answer = prepend + ifAnswer + postpend;
        this.doDestoryTarget(input, target, answer, false);
        //
        input =
            "#ifndef 0\n" + ifAnswer + "#else\n" + elseAnswer + "#endif\n";
        target = "0";
        answer = ifAnswer;
        this.doDestoryTarget(input, target, answer, true);
        answer = elseAnswer;
        this.doDestoryTarget(input, target, answer, false);
    }

    /* (non-Javadoc)
     * @see jp.sourceforge.projects.ee2e.core.cdt.doc.EE2EDocumentTest#testDestoryTarget()
     */
    public void testDestoryTargetBackslash() {
        super.testDestoryTarget();
        String input;
        String target;
        String answer;
        //
        // no target
        input = "#if define(NO_WORK) || \\  // work \n"
            + "    define(NO_WORK2)\n"
            + "#error\n"
            + "#endif\n";
        target = "work";
        answer = input;
        this.doDestoryTarget(input, target, answer, true);
        this.doDestoryTarget(input, target, answer, false);
        // no target
        input = "#if define(WORK1) || \\  // work \n"
            + "  \t  define(WORK2)\n"
            + "#error\n"
            + "#endif\n";
        target = "define(WORK1) || define(WORK2)";
        answer = "";
        this.doDestoryTarget(input, target, answer, true);
    }
    
    
    /**
     * @param input
     * @param target
     * @param answer
     * @param isIfOrElse
     */
    protected void doDestoryTarget(
        String input,
        String target,
        String answer,
        boolean isIfOrElse) {
        try {
            java.io.BufferedReader bReader;
            if (input != null) {
                java.io.StringReader sReader = new java.io.StringReader(input);
                bReader = new java.io.BufferedReader(sReader);
            } else {
                bReader = null;
            }
            EE2EMOCSharp sharp = this.createEE2ECppSharp("");
            sharp.createComposit(bReader);
            sharp.destoryTarget(target, isIfOrElse);
            java.io.StringWriter sWriter = new java.io.StringWriter();
            sharp.getWriter(sWriter, isIfOrElse);
            sWriter.close();
            Assert.assertEquals(sWriter.toString(), answer);
        } catch (IOException e) {
            Assert.fail(e.getMessage());
        }
    }

    /* (non-Javadoc)
     * @see jp.sourceforge.projects.ee2e.core.cdt.doc.EE2EDocumentTest#testGetDefines()
     */
    public void testGetDefines() {
        super.testGetDefines();
        EE2EMOCSharp sharp = this.createEE2ECppSharp(null);
        sharp.getDefines(null);
        List list = new LinkedList();
        sharp.getDefines(list);
        Assert.assertEquals(list.size(), 0);
        //
        String target = "foo";
        sharp = this.createEE2ECppSharp(target);
        list = new java.util.LinkedList();
        sharp.getDefines(list);
        Assert.assertEquals(list.size(), 0);
        //
        //
        target = "#ifdef HOGE\n";
        list = new java.util.LinkedList();
        list.add("HOGE");
        this.doGetDefines(target, "", list);
        //
        sharp = this.createEE2ECppSharp(target);
        list = new java.util.LinkedList();
        sharp.getDefines(list);
        Assert.assertEquals(list.get(0), "HOGE");
        //
        target = "#ifdef hoge\n";
        list = new java.util.LinkedList();
        list.add("hoge");
        this.doGetDefines("", target, list);
        //
        target =
            "#ifdef hoge\n"
                + "    aaa();\n"
                + "#else hero\n"
                + "    bbb()\n"
                + "#endif\n;\n";
        list = new java.util.LinkedList();
        list.add("hoge");
        list.add("hero");
        this.doGetDefines("", target, list);
        //
        target =
            "#ifdef hoge\n"
                + "    aaa();\n"
                + "#else\n"
                + "    bbb();\n"
                + "#endif\n";
        list = new java.util.LinkedList();
        list.add("hoge");
        this.doGetDefines("", target, list);
        //
        target = "#ifdef hoge\n" + "#else hero\n" + "#else\n" + "#endif\n";
        list = new java.util.LinkedList();
        list.add("hoge");
        list.add("hero");
        this.doGetDefines("", target, list);
        //
        target =
            "#ifdef hoge\n"
                + "    aaa();\n"
                + "#endif\n"
                + "    bbb();\n"
                + "#ifdef hero\n"
                + "    aaa();\n"
                + "#endif\n"
                + "    bbb();\n"
                + "#else"
                + "#endif";
        list = new java.util.LinkedList();
        list.add("hoge");
        list.add("hero");
        this.doGetDefines("", target, list);
        //
        target =
            "#ifdef hoge\n"
                + "    aaa();\n"
                + "#endif\n"
                + "    bbb();\n"
                + "  #  ifdef hoge  \n"
                + "    aaa();\n"
                + "#endif\n"
                + "    bbb();\n"
                + "#else"
                + "#endif";
        list = new java.util.LinkedList();
        list.add("hoge");
        this.doGetDefines("", target, list);
    }
    /**
     * @param top
     * @param target
     * @param list
     */
    protected void doGetDefines(String top, String target, List list) {
        List nextList = new ArrayList();
        try {
            java.io.StringReader sReader = new java.io.StringReader(target);
            java.io.BufferedReader bReader =
                new java.io.BufferedReader(sReader);
            EE2EMOCSharp sharp = this.createEE2ECppSharp(top);
            sharp.createComposit(bReader);
            sharp.getDefines(nextList);
        } catch (IOException e) {
            Assert.fail(e.getMessage());
        }
        Assert.assertEquals(nextList.size(), list.size());
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            boolean hitFlag = false;
            String string = (String) ite.next();
            Iterator nextIte = nextList.iterator();
            while (nextIte.hasNext()) {
                String nextString = (String) nextIte.next();
                if (string.equals(nextString)) {
                    hitFlag = true;
                    break;
                }
            }
            if (!hitFlag) {
                Assert.fail("not match str=" + string);
            }
        }
    }

    /** "#if AAA" -> "AAA"
    * "#error other sharp" -> ""
    * "    notsharp();" -> ""
    * */
    public void testDevideSharp() {
        String target = "foo";
        EE2EMOCSharp sharp = this.createEE2ECppSharp(target);
        String ans;
        ans = sharp.devideSharp(" #if AAA \t ");
        Assert.assertEquals(ans, "AAA");
        //
        ans = sharp.devideSharp(" #ifdef   BBB");
        Assert.assertEquals(ans, "BBB");
        //
        ans = sharp.devideSharp("#ifndef CCC");
        Assert.assertEquals(ans, "CCC");
        //
        ans = sharp.devideSharp(" #elif   DDD");
        Assert.assertEquals(ans, "DDD");
        //
        ans = sharp.devideSharp("#ifdef HOGE // herohero notsharp");
        Assert.assertEquals(ans,"HOGE");
        //
        ans = sharp.devideSharp("#ifdef HOGE /* herohero */");
        Assert.assertEquals(ans,"HOGE");
        //
        ans = sharp.devideSharp("#ifdef /* herohero */ AAA");
        Assert.assertEquals(ans,"AAA");
        //
        ans = sharp.devideSharp("#ifdef AAA /* herohero */");
        Assert.assertEquals(ans,"AAA");

        // null pattern.
        ans = sharp.devideSharp("#error other sharp");
        Assert.assertNull(ans);
        //
        ans = sharp.devideSharp("    notsharp();");
        Assert.assertNull(ans);
        //
    }

    /** get sharp comment */
    public void testCheckSharp() {
        String target = "foo";
        EE2EMOCSharp sharp = this.createEE2ECppSharp(target);
        int ans;
        ans = sharp.checkSharp(null);
        Assert.assertEquals(ans, EE2ECppSharp.NONE);
        ans = sharp.checkSharp("");
        Assert.assertEquals(ans, EE2ECppSharp.NONE);
        ans = sharp.checkSharp("#error FOO");
        Assert.assertEquals(ans, EE2ECppSharp.NONE);
        ans = sharp.checkSharp("    bar();");
        Assert.assertEquals(ans, EE2ECppSharp.NONE);
        //
        ans = sharp.checkSharp("#ifndef AAA");
        Assert.assertEquals(ans, EE2ECppSharp.IF_NDEF);
        //
        ans = sharp.checkSharp("#ifdef  BBB");
        Assert.assertEquals(ans, EE2ECppSharp.IF_DEF);
        //
        ans = sharp.checkSharp("   #elseif");
        Assert.assertEquals(ans, EE2ECppSharp.ELSE_IF);
        //
        ans = sharp.checkSharp("#elif");
        Assert.assertEquals(ans, EE2ECppSharp.ELSE_IF);
        //
        ans = sharp.checkSharp("#else  \t");
        Assert.assertEquals(ans, EE2ECppSharp.ELSE);
        //
        ans = sharp.checkSharp("#endif");
        Assert.assertEquals(ans, EE2ECppSharp.END_IF);
        //
        ans = sharp.checkSharp("#end");
        Assert.assertEquals(ans, EE2ECppSharp.END_IF);
        //
        ans = sharp.checkSharp("#if");
        Assert.assertEquals(ans, EE2ECppSharp.IF_DEF);
    }

    /** "  #if\t\tAAA" -> "#if AAA"
    * "    notsharp();" -> ""
    */
    public void testDeleteSpace() {
        String target = "foo";
        EE2EMOCSharp sharp = this.createEE2ECppSharp(target);
        String answer;
        answer = sharp.deleteSpace("  #if AAA");
        Assert.assertEquals(answer, "#if AAA");
        //
        answer = sharp.deleteSpace("#if\tAAA");
        Assert.assertEquals(answer, "#if AAA");
        //
        answer = sharp.deleteSpace("#if\t\tAAA");
        Assert.assertEquals(answer, "#if AAA");
        //
        answer = sharp.deleteSpace("#if AAA  ");
        Assert.assertEquals(answer, "#if AAA");
        //
        answer = sharp.deleteSpace("#error");
        Assert.assertEquals(answer, "#error");
        //
        answer = sharp.deleteSpace("    hogehoge();");
        Assert.assertNull(answer);
        //
        answer = sharp.deleteSpace("    hogehoge(); #if AAA");
        Assert.assertNull(answer);
        //
        answer = sharp.deleteSpace("  #if\t\tAAA");
        Assert.assertEquals(answer, "#if AAA");
        //
        answer = sharp.deleteSpace("#ifdef HOGE // herohero notsharp");
        Assert.assertEquals(answer,"#ifdef HOGE");
        //
        answer = sharp.deleteSpace("#ifdef HOGE /* herohero */");
        Assert.assertEquals(answer,"#ifdef HOGE");
        //
        answer = sharp.deleteSpace("#ifdef /* herohero */ AAA");
        Assert.assertEquals(answer,"#ifdef AAA");
        //
        answer = sharp.deleteSpace("#ifdef AAA /* herohero */");
        Assert.assertEquals(answer,"#ifdef AAA");
    }
    public EE2EMOCSharp createEE2ECppSharp(String target) {
        return new EE2EMOCSharp(target);
    }
    public EE2ECppDocument createEE2ECppDocument(String target) {
        return this.createEE2ECppSharp(target);
    }
    /** MOC object */
    private class EE2EMOCSharp extends EE2ECppSharp {
        public EE2EMOCSharp(String string) {
            super(string);
        }
    }
}
