package jp.sourceforge.projects.ee2e.core.indent;


/**
 * Abstract class for Java indent
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentCppArrayTest extends EE2EIndentBaseTest {

	/**
	 * Constructor for EE2EIndentJavaTest.
	 * @param name
	 */
	public EE2EIndentCppArrayTest(String name) {
		super(name);
	}
    public EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentJava(4,false);
    }

    public void testArray1st() throws EE2EIndentException {
        String base =
            "static int work = 10;\n" +
            "int [] work = {{10,20,30},\n";
        String now = "{23,45,65},";
        String answer = base + this.getSpace(4) + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
    public void testArray2st() throws EE2EIndentException {
        String base =
            "static int work = 10;\n" +
            "int [] work = {{10,20,30},\n" +
            "    {23,45,65},\n";
        String now = "{45,46,67}};";
        String answer = base + this.getSpace(4) + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
}
