package jp.sourceforge.projects.ee2e.core.editors;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJsp extends EE2EIndentBehavior {
    /** constractor */
    public EE2EIndentJsp(EE2EIndentXML xml) {
        this.javaIndent = new EE2EIndentJava(4);
        this.xmlIndent = xml;
    }
    private EE2EIndentJava javaIndent;
    private EE2EIndentXML xmlIndent;

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    protected void doIndent(int offset, IDocument document)
        throws BadLocationException {
        //
        int nextOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        boolean isJavaIndent = false;
        while (0 < nextOffset) {
            nextOffset = EE2ELispBase.get().findCharsBackward(nextOffset, "<>", document);
            if (nextOffset <= 0) {
                break;
            }
            char ch = document.getChar(nextOffset);
            if ('<' == ch) {
                char nextCh = document.getChar(nextOffset + 1);
                if (('?' == nextCh) || ('%' == nextCh)) {
                    isJavaIndent = true;
                    break;
                }
            } else if ('>' == ch) {
                char nextCh = document.getChar(nextOffset - 1);
                if (('?' == nextCh) || ('%' == nextCh)) {
                    isJavaIndent = false;
                    break;
                }
            } else {
                isJavaIndent = false;
            }
            nextOffset--;
        }
        if (isJavaIndent) {
            EE2EDebug.printf(5, "javaMode");
            this.javaIndent.doIndent(offset, document);
        } else {
            EE2EDebug.printf(5, "xmlMode");
            this.xmlIndent.doIndent(offset, document);
        }
    }
}
