/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ELispBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EE2EIndentXML
extends EE2EIndentBehavior {
    private int indentSize;
    private boolean emptyLine;

    public EE2EIndentXML(int indentSize, boolean emptyLine) {
        this.indentSize = indentSize;
        this.emptyLine = emptyLine;
    }

    protected void doIndent(int offset, IDocument document) throws BadLocationException {
        if (this.emptyLine && this.doEmptyLine(offset, document)) {
            return;
        }
        this.indentCommandPost(offset, document);
    }

    private boolean doEmptyLine(int offset, IDocument document) throws BadLocationException {
        int nextOffset;
        int i = nextOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        while (i < document.getLength()) {
            if (' ' != document.getChar(i) && '\t' != document.getChar(i) && '\r' != document.getChar(i) && '\n' != document.getChar(i)) break;
            if (' ' != document.getChar(i) && '\t' != document.getChar(i)) {
                EE2ELispBase.get().indentTo(offset, 0, document);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void indentCommandPost(int offset, IDocument document) throws BadLocationException {
        char nowChar;
        offset = EE2ELispBase.get().beginningOfLine(offset, document);
        if (offset <= 0 || EE2ELispBase.get().skipCharsBackward(offset - 1, " \t\r\n", document) <= 0) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }
        int endOffset = EE2ELispBase.get().skipCharsBackward(offset - 1, " \t\r\n", document);
        if (document.getLength() <= endOffset) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }
        int startOffset = EE2ELispBase.get().beginningOfLine(endOffset, document);
        int stndardLen = EE2ELispBase.get().indentLen(startOffset, document);
        startOffset = EE2ELispBase.get().skipCharsForward(startOffset, " \t", document, endOffset) + 1;
        if (startOffset <= 1) {
            startOffset = 0;
        }
        int nowOffset = startOffset;
        int mark = 0;
        while ('<' == (nowChar = document.getChar(nowOffset = EE2ELispBase.get().findCharsForward(nowOffset, "<>", document, endOffset))) || '>' == nowChar) {
            mark += this.doPrependIndentMark(startOffset, nowOffset, document);
            ++nowOffset;
        }
        if (mark < -1) {
            mark = -1;
        }
        if (1 < mark) {
            mark = 1;
        }
        mark += this.checkUnbarance(startOffset, endOffset, document);
        EE2ELispBase.get().indentTo(offset, stndardLen + (mark += this.doTargetMark(offset, document)) * this.indentSize, document);
    }

    private int doPrependIndentMark(int startOffset, int nowOffset, IDocument document) throws BadLocationException {
        char startChar = document.getChar(startOffset);
        char startNextChar = document.getChar(startOffset + 1);
        char backChar = nowOffset <= 0 ? (char)' ' : (char)document.getChar(nowOffset - 1);
        char nowChar = document.getChar(nowOffset);
        char nextChar = document.getChar(nowOffset + 1);
        int mark = 0;
        if ('<' == nowChar) {
            if ('/' == nextChar) {
                ++mark;
                if ('<' != startChar || '/' != startNextChar) {
                    --mark;
                }
            } else {
                mark = this.isForWord(nextChar) ? ++mark : (mark += 2);
            }
        } else if ('>' == nowChar) {
            mark = !this.isBackWord(backChar) ? --mark : (mark -= 2);
        }
        return mark;
    }

    private boolean isForWord(char forWord) {
        return '!' == forWord || '?' == forWord;
    }

    private boolean isBackWord(char backChar) {
        return '/' == backChar || '%' == backChar || ']' == backChar;
    }

    private int doTargetMark(int offset, IDocument document) throws BadLocationException {
        int nowOffset = EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1;
        char startChar = document.getChar(nowOffset);
        char startNextChar = document.getChar(nowOffset + 1);
        if ('<' == startChar && '/' == startNextChar) {
            return -1;
        }
        return 0;
    }

    private int checkUnbarance(int startOffset, int endOffset, IDocument document) throws BadLocationException {
        int count = 0;
        int last = startOffset;
        int i = startOffset;
        while (i <= endOffset) {
            char ch = document.getChar(i);
            if ('<' == ch) {
                ++count;
            } else if ('>' == ch) {
                --count;
                last = i;
            }
            ++i;
        }
        if (count < 0) {
            char lastBackCh = document.getChar(last - 1);
            if (this.isBackWord(lastBackCh)) {
                return 0;
            }
            --startOffset;
            startOffset = EE2ELispBase.get().findCharsBackward(startOffset, "<", document);
            char nextChar = document.getChar(startOffset + 1);
            if (this.isForWord(nextChar)) {
                return 0;
            }
            return 1;
        }
        return 0;
    }
}

