/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.ttledit;

import java.util.ArrayList;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.relax.EE2RDefvar;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import jp.sourceforge.projects.ee2e.core.ttledit.TtlColorProvider;
import jp.sourceforge.projects.ee2e.core.ttledit.TtlWhitespaceDetector;
import jp.sourceforge.projects.ee2e.core.ttledit.TtlWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class TtlScanner
extends RuleBasedScanner {
    public static final String TARGET = "ttl";
    public static final String KEYWORDS = "ttl-kywords-table";
    public static final String TYPES = "ttl-types-table";
    public static final String CONSTANTS = "ttl-constants-table";

    public TtlScanner(TtlColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.KEYWORD)));
        Token type = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.TYPE)));
        Token constants = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.CONSTANTS)));
        Token string = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(TtlColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule(";", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new TtlWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new TtlWordDetector(), (IToken)other);
        this.getDefvarData(wordRule, KEYWORDS, (IToken)keyword);
        this.getDefvarData(wordRule, TYPES, (IToken)type);
        this.getDefvarData(wordRule, CONSTANTS, (IToken)constants);
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    protected void getDefvarData(WordRule wordRule, String string, IToken token) {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(TARGET);
        if (ee2e == null) {
            EE2EDebug.printf(1, "getDefvarData/ee2e is null");
            return;
        }
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(string);
        if (defvar == null) {
            EE2EDebug.printf(1, "getDefvarData/defvar is null");
            return;
        }
        int i = 0;
        while (i < defvar.getContentCount()) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (choice instanceof EE2RTag) {
                EE2RTag tag = (EE2RTag)choice;
                wordRule.addWord(tag.getName(), token);
            }
            ++i;
        }
    }
}

