package jp.sourceforge.projects.ee2e.core.cf;

import jp.sourceforge.projects.ee2e.core.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates. To enable and disable the
 * creation of type comments go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation.
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EGetFactory {
    public EE2EGetFactory() {
    }

    public static EE2EGetFactory get() {
        if (instance == null) {
            instance = new EE2EGetFactory();
        }
        return instance;
    }

    private static EE2EGetFactory instance;

    /** used by EE2EReload */
    public void clearInstance() {
        instance = null;
    }

    /** set object which other distributors offer */
    public void setEE2ECFOterhDistributors(EE2ECFOterhDistributors cf) {
        if (this.eE2ECFSet == null) {
            this.eE2ECFSet = new java.util.HashSet();
        }
        this.eE2ECFSet.add(cf);
    }

    private java.util.Set eE2ECFSet;

    public java.util.Set getEE2ECFOterhDistributors() {
        return eE2ECFSet;
    }

    public final EE2ECF getFactory(String fileName) {
        EE2EDebug.printf(5, "EE2ECreateIMenuManager:getFactory target="
                + fileName);
        if (eE2ECFSet != null) {
            java.util.Iterator ite = eE2ECFSet.iterator();
            while (ite.hasNext()) {
                EE2ECFOterhDistributors cf = (EE2ECFOterhDistributors) ite
                        .next();
                if (cf.isUseable(fileName)) {
                    return cf.getEE2ECF();
                }
            }
        }
        if (fileName.equalsIgnoreCase("build.xml")
                || ((0 == fileName.indexOf("build")) && (0 < fileName
                        .indexOf(".xml")))) {
            return getEE2ECFAnt();
        }
        if (fileName.equalsIgnoreCase("struts-config.xml")) {
            return getEE2ECFScof();
        }
        if (fileName.equalsIgnoreCase("web.xml")) {
            return getEE2ECFWapp();
        }
        if (fileName.equalsIgnoreCase("server.xml")) {
            return getEE2ECFSev();
        }
        int dotLoc = fileName.lastIndexOf('.');
        String ext;
        if (0 <= dotLoc) {
            ext = fileName.substring(dotLoc + 1);
        } else {
            EE2EDebug.printf(1, "no extention exception! file=" + fileName);
            return getEE2ECFText();
        }
        EE2EDebug.printf(10, "EE2ECreateIMenuManager:getFactory ext=" + ext);
        if (ext.equalsIgnoreCase("xi")) {
            return getEE2ECFXi();
        }
        if (ext.equalsIgnoreCase("xhtml") || ext.equalsIgnoreCase("html")
                || ext.equalsIgnoreCase("xhtm") || ext.equalsIgnoreCase("htm")) {
            return getEE2ECFXhtml();
        }
        if (ext.equalsIgnoreCase("jsp") || ext.equalsIgnoreCase("jspf")) {
            return getEE2ECFJsp();
        }
        if (ext.equalsIgnoreCase("rlx") || ext.equalsIgnoreCase("rxm")
                || ext.equalsIgnoreCase("rxg")) {
            return getEE2ECFRlx();
        }
        if (ext.equalsIgnoreCase("sdoc")) {
            return getEE2ECFSdoc();
        }
        if (ext.equalsIgnoreCase("ee2e")) {
            return getEE2ECFEe2e();
        }
        if (ext.equalsIgnoreCase("java") || ext.equalsIgnoreCase("class")) {
            return getEE2ECFJava();
        }
        if (ext.equalsIgnoreCase("ttl")) {
            return getEE2ECFTtl();
        }
        if (ext.equalsIgnoreCase("mib")) {
            return getEE2ECFSnmp();
        }
        if (ext.equalsIgnoreCase("el")) {
            return getEE2ECFLisp();
        }
        if ((ext.equalsIgnoreCase("xsl")) || (ext.equalsIgnoreCase("xsd"))
                || (ext.equalsIgnoreCase("xslt"))) {
            return getEE2ECFXsl();
        }
        if (ext.equalsIgnoreCase("tld")) {
            return getEE2ECFTld();
        }
        if (ext.equalsIgnoreCase("jnlp") || ext.equalsIgnoreCase("xjnlp")) {
            return getEE2ECFJnlp();
        }
        if ((fileName.indexOf("toc") == 0) && ext.equalsIgnoreCase("xml")) {
            return getEE2ECFToc();
        }
        if (ext.equalsIgnoreCase("pl") || ext.equalsIgnoreCase("ph")
                || ext.equalsIgnoreCase("cgi")) {
            return getEE2ECFPerl();
        }
        if (ext.equalsIgnoreCase("rb")) {
            return getEE2ECFRuby();
        }
        if (ext.equalsIgnoreCase("tex")) {
            return getEE2ECFTex();
        }
        if (ext.equalsIgnoreCase("bat")) {
            return getEE2ECFBat();
        }
        if (ext.equalsIgnoreCase("xml") || ext.equalsIgnoreCase("bml")
                || ext.equalsIgnoreCase("diejaxaco")) {
            return getEE2ECFXml();
        }
        if (ext.equalsIgnoreCase("dtd")) {
            return getEE2ECFDtd();
        }
        if (ext.equalsIgnoreCase("txt")) {
            return getEE2ECFText();
        }
        //
        // ftHgłJava[hŊJ悤ɂ
        return getEE2ECFJava();
        //return getEE2ECFText();
    }

    private final EE2ECF getEE2ECFAnt() {
        if (eE2ECFAnt == null) {
            eE2ECFAnt = new EE2ECFAnt();
        }
        return eE2ECFAnt;
    }

    private final EE2ECF getEE2ECFSev() {
        if (eE2ECFSev == null) {
            eE2ECFSev = new EE2ECFSev();
        }
        return eE2ECFSev;
    }

    private final EE2ECF getEE2ECFScof() {
        if (eE2ECFScof == null) {
            eE2ECFScof = new EE2ECFScof();
        }
        return eE2ECFScof;
    }

    private final EE2ECF getEE2ECFWapp() {
        if (eE2ECFWapp == null) {
            eE2ECFWapp = new EE2ECFWapp();
        }
        return eE2ECFWapp;
    }

    private final EE2ECF getEE2ECFText() {
        if (eE2ECFText == null) {
            eE2ECFText = new EE2ECFText();
        }
        return eE2ECFText;
    }

    private final EE2ECF getEE2ECFJava() {
        if (eE2ECFJava == null) {
            eE2ECFJava = new EE2ECFJava();
        }
        return eE2ECFJava;
    }

    private final EE2ECF getEE2ECFEe2e() {
        if (eE2ECFEe2e == null) {
            eE2ECFEe2e = new EE2ECFEe2e();
        }
        return eE2ECFEe2e;
    }

    private final EE2ECF getEE2ECFXi() {
        if (eE2ECFXi == null) {
            eE2ECFXi = new EE2ECFXi();
        }
        return eE2ECFXi;
    }

    private final EE2ECF getEE2ECFXhtml() {
        if (eE2ECFXhtml == null) {
            eE2ECFXhtml = new EE2ECFXhtml();
        }
        return eE2ECFXhtml;
    }

    private final EE2ECF getEE2ECFJsp() {
        if (eE2ECFJsp == null) {
            eE2ECFJsp = new EE2ECFJsp();
        }
        return eE2ECFJsp;
    }

    private final EE2ECF getEE2ECFRlx() {
        if (eE2ECFRlx == null) {
            eE2ECFRlx = new EE2ECFRlx();
        }
        return eE2ECFRlx;
    }

    private final EE2ECF getEE2ECFSdoc() {
        if (eE2ECFSdoc == null) {
            eE2ECFSdoc = new EE2ECFSdoc();
        }
        return eE2ECFSdoc;
    }

    private final EE2ECF getEE2ECFXsl() {
        if (eE2ECFXsl == null) {
            eE2ECFXsl = new EE2ECFXsl();
        }
        return eE2ECFXsl;
    }

    private final EE2ECF getEE2ECFTld() {
        if (eE2ECFTld == null) {
            eE2ECFTld = new EE2ECFTld();
        }
        return eE2ECFTld;
    }

    private final EE2ECF getEE2ECFJnlp() {
        if (eE2ECFJnlp == null) {
            eE2ECFJnlp = new EE2ECFJnlp();
        }
        return eE2ECFJnlp;
    }

    private final EE2ECF getEE2ECFTtl() {
        if (eE2ECFTtl == null) {
            eE2ECFTtl = new EE2ECFTtl();
        }
        return eE2ECFTtl;
    }

    private final EE2ECF getEE2ECFSnmp() {
        if (eE2ECFSnmp == null) {
            eE2ECFSnmp = new EE2ECFSnmp();
        }
        return eE2ECFSnmp;
    }

    private final EE2ECF getEE2ECFLisp() {
        if (eE2ECFLisp == null) {
            eE2ECFLisp = new EE2ECFLisp();
        }
        return eE2ECFLisp;
    }

    private final EE2ECF getEE2ECFToc() {
        if (eE2ECFToc == null) {
            eE2ECFToc = new EE2ECFToc();
        }
        return eE2ECFToc;
    }

    private final EE2ECF getEE2ECFBat() {
        if (eE2ECFBat == null) {
            eE2ECFBat = new EE2ECFBat();
        }
        return eE2ECFBat;
    }

    private final EE2ECF getEE2ECFTex() {
        if (eE2ECFTex == null) {
            eE2ECFTex = new EE2ECFTex();
        }
        return eE2ECFTex;
    }

    private final EE2ECF getEE2ECFRuby() {
        if (eE2ECFRuby == null) {
            eE2ECFRuby = new EE2ECFRuby();
        }
        return eE2ECFRuby;
    }

    private final EE2ECF getEE2ECFPerl() {
        if (eE2ECFPerl == null) {
            eE2ECFPerl = new EE2ECFPerl();
        }
        return eE2ECFPerl;
    }

    private final EE2ECF getEE2ECFXml() {
        if (eE2ECFXml == null) {
            eE2ECFXml = new EE2ECFXml();
        }
        return eE2ECFXml;
    }

    private final EE2ECF getEE2ECFDtd() {
        if (eE2ECFDtd == null) {
            eE2ECFDtd = new EE2ECFDtd();
        }
        return eE2ECFDtd;
    }

    private EE2ECF eE2ECFAnt;

    private EE2ECF eE2ECFScof;

    private EE2ECF eE2ECFWapp;

    private EE2ECF eE2ECFSev;

    private EE2ECF eE2ECFText;

    private EE2ECF eE2ECFJava;

    private EE2ECF eE2ECFEe2e;

    private EE2ECF eE2ECFXi;

    private EE2ECF eE2ECFXhtml;

    private EE2ECF eE2ECFJsp;

    private EE2ECF eE2ECFRlx;

    private EE2ECF eE2ECFSdoc;

    private EE2ECF eE2ECFXsl;

    private EE2ECF eE2ECFTld;

    private EE2ECF eE2ECFJnlp;

    private EE2ECF eE2ECFTtl;

    private EE2ECF eE2ECFSnmp;

    private EE2ECF eE2ECFLisp;

    private EE2ECF eE2ECFToc;

    private EE2ECF eE2ECFBat;

    private EE2ECF eE2ECFTex;

    private EE2ECF eE2ECFRuby;

    private EE2ECF eE2ECFPerl;

    private EE2ECF eE2ECFXml;

    private EE2ECF eE2ECFDtd;
}