package jp.sourceforge.projects.ee2e.core.editors;
import java.net.MalformedURLException;

import jp.sourceforge.projects.ee2e.core.relax.*;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.display.*;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.text.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates. To enable and disable the
 * creation of type comments go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation.
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EDependCompletent
    implements EE2EMenuBehavior, EE2EDisplayCompletion {

    /** strListIns type */
    public static final String SECTION = "section";
    public static final String BEGIN = "begin";
    public static final String LEARGE = "learge";
    public static final String BIG = "big";
    public static final String RETURN = "return";

    /** attribute type */
    public static final String ENUMULATION = "enumeration";
    public static final String INTEGER = "integer";
    public static final String FILE = "file";
    public static final String FILE_NAME = "filename";
    public static final String XML_FILE_NAME = "xml-file-name";
    public static final String FOLDER = "folder";
    public static final String XML_SAME_ALIST = "xml-same-alist";
    public static final String XI_XPAHT = "xi-xpath";
    public static final String HTML_IMAGE_FILE_NAME = "html-image-file-name";
    public static final String HTML_IMAGE_ALT = "html-image-alt";
    public static final String HTML_IMAGE_WIDTH = "html-image-width";
    public static final String HTML_IMAGE_HEIGHT = "html-image-height";
    public static final String HTML_SET_REV_LINK = "html-set-rev-link";
    public static final String HTML_SET_REL_LINK = "html-set-rel-link";
    public static final String HTML_SET_CSS_STYLE = "html-set-css-style";
    public static final String HTML_SET_META_TYPES = "html-set-meta-types";
    public static final String HTML_SET_HTTP_EQUIV = "html-set-http-equiv";
    public static final String HTML_SET_CONTENT = "html-set-content";
    public static final String JSP_SAME_ALIST = "jsp-same-alist";
    public static final String JSP_ACTION_ALIST = "jsp-action-alist";
    public static final String SDOC_IMAGE_STYLE = "sdoc-image-style";
    public static final String JSP_JSTL_EL = "jsp-jstl-el";
    public static final String JSP_JSPL_VAR_SOURCE = "jsp-jspl-var-source";

    /** meta-type */
    public static final String META_KEYWORD = "keywords";
    public static final String META_AUTHER = "author";
    public static final String META_COPYRIGHT = "copyright";
    public static final String META_DATE = "date";
    public static final String META_GENERATOR = "generator";
    public static final String META_CONTENT = "Content-Type";
    public static final String META_REFRESH = "refresh";
    //
    public static final String META_STYLE_SHEET = "stylesheet";

    /** target defvarIns */
    public static final String XI_PATH_NINJA = "xi-path-ninja";
    public static final String XI_PATH_FORMULA = "xi-path-formula";
    public static final String HTML_CHARSET = "html-charset";
    public static final String HTML_LINK_TYPES = "html-link-types";
    public static final String JSP_JSPL_PATH_FORMULA = "jsp-jstl-path-formula";
    public static final String JSP_JSPL_OBJECT = "jsp-jstl-object";
    /** meta-type */
    public static final String GENERATOR =
        "EE2E / http://park.ruru.ne.jp/ando/work/who/ee2e/";

    /** constractor */
    public EE2EDependCompletent(
        EE2RStructureList structureList,
        EE2EIndentBehavior indentBehavior,
        String oneString) {
        this.strListIns = structureList;
        this.indentBehavior = indentBehavior;
        this.oneString = oneString;
        this.imageFileName = null;
        this.imageLength = -1;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.tagExtFlag = false;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor,
     *      IDocument, ITextSelection)
     */
    public void doBehavior(
        AbstractTextEditor editor,
        IDocument document,
        ITextSelection textSelection)
        throws BadLocationException {
        this.initialize();
        this.editorIns = editor;
        if (this.strListIns == null) {
            EE2EDebug.printf(1, "doBehavior/getStructureList is null");
            return;
        }
        this.defvarIns = EE2EToolkit.get().getDefvar(this.strListIns);
        if (this.defvarIns == null) {
            EE2EDebug.printf(10, "one completention");
            this.finalReturnAction();
            return;
        }
        EE2EMiniBufferView.showEE2EDisplayCompletion(this);
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion#getTitleText()
     */
    public String getTitleText() {
        if (this.tagCompletent == null) {
            return "EE2E Identifer(default:" + strListIns.getDefault() + ")";
        }
        return "EE2E Argument("
            + EE2EToolkit
                .get()
                .getAttribute(this.nextTag, this.argList.size())
                .getName()
            + "/"
            + this.nextTag.getName()
            + ")";
    }
    public java.util.Collection getTagList() {
        if (this.nextTag == null) {
            return null;
        }
        java.util.Collection col = new java.util.LinkedList();
        for (int i = 0; i < this.nextTag.getAttributeCount(); i++) {
            EE2RAttribute attr = this.nextTag.getAttribute(i);
            String answer = attr.getName();
            if (0 < attr.getEnumerationCount()) {
                EE2REnumeration enumeration = attr.getEnumeration(0);
                if ((enumeration.getName() != null)
                    && (!enumeration.getName().equals(""))) {
                    answer = answer + " / " + enumeration.getName() + "...";
                } else {
                    answer = answer + " (" + enumeration.getRef() + ")";
                }
            }
            col.add((String) answer);
        }
        return col;
    }

    public int getTagListSelect() {
        if ((this.nextTag == null) || (this.nextAttribute == null)) {
            return -1;
        }
        for (int i = 0; i < this.nextTag.getAttributeCount() ; i++) {
            EE2RAttribute attr = this.nextTag.getAttribute(i);
            if (attr == this.nextAttribute) {
                return i;
            }
        }
        return -1;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion#allCompletions(String)
     */
    public java.util.Collection allCompletions(String string) {
        if (this.tagCompletent == null) {
            if (!tagExtFlag) {
                tagExtFlag = true;
                checkTagExtFlag(this.strListIns);
            }
            return EE2EToolkit.get().getTagSet(this.defvarIns);
        }
        return this.getElementSet(this.nextAttribute, editorIns, string);
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion#returnAction(String)
     */
    public void returnAction(String string) {
        if (this.tagCompletent == null) {
            this.argList = new java.util.LinkedList();
            if ((string == null) || string.equals("")) {
                this.tagCompletent = this.strListIns.getDefault();
            } else {
                this.tagCompletent = string;
                this.strListIns.setDefault(this.tagCompletent);
            }
            this.nextTag = EE2EToolkit.get().getTag(defvarIns, this.tagCompletent);
        } else {
            this.argList.add(string);
        }
        this.nextAttribute =
            EE2EToolkit.get().getAttribute(this.nextTag, this.argList.size());
        if (this.nextAttribute == null) {
            this.finalReturnAction();
        }
        return;
    }

    /**
     * Operation when complement processing finishes is described.
     */
    protected void finalReturnAction() {
        EE2EDebug.printf(5, "finalReturnAction");
        if (this.editorIns == null) {
            EE2EDebug.printf(3, "[return] action -- editorIns editable");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        /*
         * if ((EE2EToolkit.get().getEE2EDisplayCompletion() == null) ||
         * (EE2EToolkit.get().getEE2EDisplayCompletion().getDisplay() == null) ||
         * EE2EToolkit .getEE2EDisplayCompletion() .getDisplay() .isDisposed()) {
         * EE2EDebug.printf(3, "[return] action -- null");
         * EE2EToolkit.get().getEE2EDisplayDespose(); return;
         */
        if (!this.editorIns.isEditable()) {
            EE2EDebug.printf(3, "[return] action -- editable");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        IDocument document = EE2EToolkit.get().getEditorToDocument(this.editorIns);
        if (this.editorIns.getDocumentProvider() == null) {
            EE2EDebug.printf(3, "not getDocumentProvider()!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        if (document == null) {
            EE2EDebug.printf(3, "not document!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        ISelection selection = editorIns.getSelectionProvider().getSelection();
        if (selection == null) {
            EE2EDebug.printf(3, "not selection!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        if (!(selection instanceof ITextSelection)) {
            EE2EDebug.printf(3, "not instanceof ITextSelection!!");
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        ITextSelection textSelection = (ITextSelection) selection;
        try {
            EE2EToolkit.get().doStructure(
                this.strListIns,
                this.argList,
                this.nextTag,
                this.indentBehavior,
                editorIns,
                document,
                textSelection);
        } catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException!!" + e.getMessage());
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
        EE2EMiniBufferView.removeEE2EDisplayCompletion();
        EE2EDebug.printf(3, "finalReturnAction:dispose");
        return;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString(
            EE2EPlugin.getResourceString("action." + strListIns.getType())
                + "(&"
                + this.oneString
                + ")");
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString(
            "action." + strListIns.getType() + ".tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion#dispose()
     */
    public void dispose() {
        this.initialize();
        EE2EDebug.printf(3, "[return] dispose");
    }

    /** An element is set up. */
    protected java.util.Collection getElementSet(
        EE2RAttribute attr,
        AbstractTextEditor editor,
        String string) {
        if (attr == null) {
            return null;
        }
        if ((attr.getRef() != null) && (!attr.getRef().equals(""))) {
            attr = EE2EToolkit.get().getAttribute(attr.getRef());
        }
        java.util.Set set = new java.util.TreeSet();
        if (0 < attr.getEnumerationCount()) {
            for (int i = 0; i < attr.getEnumerationCount(); i++) {
                EE2REnumeration elem = attr.getEnumeration(i);
                getElementSetLoop(attr, elem, editor, string, set);
            }
        } else {
            getElementSetSameName(attr, null, editor, set);
        }
        return set;
    }

    /** The target element is substituted for col. */
    protected void getElementSetLoop(
        EE2RAttribute attr,
        EE2REnumeration elem,
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {

        if ((elem.getRef() == null)
            || elem.getRef().equals("")
            || elem.getRef().equals(ENUMULATION)) {
            if ((elem.getName() != null) && (!elem.getName().equals(""))) {
                col.add(elem.getName());
            } else {
                EE2EDebug.printf(1, "enum error! name=" + attr.getName());
            }
        } else if (elem.getRef().equals(INTEGER)) {
            getElementSetInteger(string, col);
        } else if (
            elem.getRef().equals(FILE)
                || elem.getRef().equals(FILE_NAME)
                || elem.getRef().equals(XML_FILE_NAME)) {
            getElementSetFile(editor, string, col);
        } else if (elem.getRef().equals(FOLDER)) {
            getElementSetFolder(editor, string, col);
        } else if (
            elem.getRef().equals(XML_SAME_ALIST)
                || elem.getRef().equals(JSP_SAME_ALIST)
                || elem.getRef().equals(JSP_ACTION_ALIST)) {
            getElementSetSameName(attr, elem, editor, col);
        } else if (elem.getRef().equals(XI_XPAHT)) {
            getElementSetXiPath(editor, string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_FILE_NAME)) {
            getElementSetImageFile(editor, string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_ALT)) {
            getElementSetImageAlt(col);
        } else if (elem.getRef().equals(HTML_IMAGE_WIDTH)) {
            getElementSetImageWidth(string, col);
        } else if (elem.getRef().equals(HTML_IMAGE_HEIGHT)) {
            getElementSetImageHeight(string, col);
        } else if (elem.getRef().equals(SDOC_IMAGE_STYLE)) {
            getElementSetImageSdocStyle(col);
        } else if (elem.getRef().equals(HTML_SET_REV_LINK)) {
            getElementRevLink(col);
        } else if (elem.getRef().equals(HTML_SET_REL_LINK)) {
            getElementRelLink(col);
        } else if (elem.getRef().equals(HTML_SET_CSS_STYLE)) {
            getElementCssStyle(col);
        } else if (elem.getRef().equals(HTML_SET_META_TYPES)) {
            getElementSetMetaTypes(col);
        } else if (elem.getRef().equals(HTML_SET_HTTP_EQUIV)) {
            getElementSetHttpEquiv(col);
        } else if (elem.getRef().equals(HTML_SET_CONTENT)) {
            getElementSetContent(col);
        } else if (elem.getRef().equals(JSP_JSTL_EL)) {
            getElementSetJspJstlEl(editor, string, col);
        } else if (null != EE2EToolkit.get().getDefvar(elem.getRef())) {
            EE2RDefvar newDefvar = EE2EToolkit.get().getDefvar(elem.getRef());
            for (int j = 0; j < newDefvar.getContentCount(); j++) {
                IEE2RDefvarChoice choice = newDefvar.getContent(j);
                if (!(choice instanceof EE2REnumeration)) {
                    EE2EDebug.printf(
                        3,
                        "instanceof error ref=" + elem.getRef());
                    continue;
                }
                EE2REnumeration next = (EE2REnumeration) choice;
                getElementSetLoop(attr, next, editor, string, col);
            }
        } else {
            EE2EDebug.printf(1, "not select! name=" + elem.getRef());
        }
    }

    protected void getElementSetInteger(
        String string,
        java.util.Collection col) {
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < 9; i++) {
            col.add(string + i);
        }
    }

    /** The target file is substituted for col. */
    protected void getElementSetFile(
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {
        if (string == null) {
            string = "";
        }
        java.io.File targetParent;
        if (0 < string.length()) {
            char ch = string.charAt(string.length() - 1);
            if ((ch == '/') || (ch == '\\')) {
                string = string + "dummy.html";
            }
            string = EE2EToolkit.get().replaceFileSeparator(string);
            targetParent = new java.io.File(string).getParentFile();
        } else {
            targetParent = new java.io.File(".");
        }
        if (targetParent == null) {
            targetParent = new java.io.File(".");
        }
        java.io.File target = getTargetFile(editor, string, targetParent);
        if (target == null) {
            return;
        }
        java.io.File[] fileList = target.listFiles();
        if (fileList == null) {
            return;
        }

        for (int i = 0; i < fileList.length; i++) {
            String answer;
            java.io.File anserFile =
                new java.io.File(
                    targetParent,
                    fileList[i].getName().toString());
            answer = anserFile.toString();
            if (fileList[i].isDirectory()) {
                answer = answer + "/";
            }
            answer = EE2EToolkit.get().replaceFileSeparator(answer);
            col.add(answer);
            if ((2 < answer.length())
                && (answer.charAt(0) == '.')
                && (answer.charAt(1) == '/')) {
                col.add(answer.substring(2));
            }
        }
    }

    protected java.io.File getTargetFile(
        AbstractTextEditor editor,
        String string,
        java.io.File targetParent) {
        java.io.File target;
        if ((0 < string.indexOf("://"))
            || (0 < string.indexOf("mailto:"))
            || (0 < string.indexOf("$"))
            || (0 < string.indexOf("{"))
            || (0 < string.indexOf("}"))) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            System.out.println("Invalid Input: Must be IFileEditorInput");
            return null;
        }
        IFileEditorInput fileInput = (IFileEditorInput) editorInput;
        if ((0 < string.indexOf(":"))
            || ((0 < string.length())
                && ((string.charAt(0) == '/') || (string.charAt(0) == '\\')))) {
            target = targetParent;
        } else {
            IFile iFile = fileInput.getFile();
            IContainer container = iFile.getParent();
            IPath path = container.getLocation();
            java.io.File parentFile = path.toFile();
            //
            target = new java.io.File(parentFile, targetParent.toString());
        }
        return target;
    }

    /** The target folder is substituted for col. */
    protected void getElementSetFolder(
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {
        getElementSetFile(editor, string, col);
    }

    /** The target same name attribute is substituted for col. */
    protected void getElementSetSameName(
        EE2RAttribute attr,
        EE2REnumeration elem,
        AbstractTextEditor editor,
        java.util.Collection col) {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        try {
            if ((elem == null) || (elem.getEnvCount() <= 0)) {
                getElementSetSameNameSingle(attr.getName(), document, col);
                return;
            }
            for (int i = 0; i < elem.getEnvCount(); i++) {
                EE2REnv env = elem.getEnv(i);
                getElementSetSameNameSingle(env.getName(), document, col);
            }
        } catch (BadLocationException e) {
            EE2EDebug.printf(1, "instanceof error e=" + e.getMessage());
        }
    }

    /** The target same name attribute is substituted for col(single). */
    protected void getElementSetSameNameSingle(
        String target,
        IDocument document,
        java.util.Collection col)
        throws BadLocationException {
        //
        String findString = target + "=\"";
        int nowResult = 0;
        FindReplaceDocumentAdapter adapter =
            new FindReplaceDocumentAdapter(document);
        while (true) {
            IRegion resion =
                adapter.find(nowResult, findString, true, true, false, false);
            if (resion == null) {
                break;
            }
            nowResult = resion.getOffset();
            if (nowResult < 0) {
                break;
            }
            nowResult += findString.length();
            int len =
                EE2ELispBase.get().findCharsForward(
                    nowResult,
                    "\"<>\r\n",
                    document);
            String data = document.get(nowResult, len - nowResult);
            col.add(data);
            nowResult = len + 1;
        }
    }

    /** The target Xi-XPath is substituted for col. */
    protected void getElementSetXiPath(
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {
        int lastOffset =
            getLastOffset(string, " $=@\\/*|&()[]{}<>!\'#%~^+-,?:;");
        // not .
        String plusData;
        EE2RAttribute attr = new EE2RAttribute();
        if (lastOffset < 0) {
            plusData = "";
            col.add(plusData + "$");
            col.add(plusData + "/");
        } else {
            plusData = string.substring(0, lastOffset + 1);
            char lastChar = string.charAt(lastOffset);
            if ((lastChar == ' ')
                || (lastChar == ')')
                || (lastChar == '}')
                || (lastChar == ']')) {
                java.util.Collection formulaCollection =
                    new java.util.ArrayList();
                getDefvarData(XI_PATH_FORMULA, formulaCollection);
                java.util.Iterator ite = formulaCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = plusData + ((String) ite.next()) + " ";
                    col.add(sameName);
                }
                col.add(plusData + "$");
                col.add(plusData + "/");
            } else if (lastChar == '/') {
                java.util.Collection tagCollection = new java.util.ArrayList();
                getElementSetSameTag(editor, tagCollection);
                java.util.Iterator ite = tagCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = plusData + ((String) ite.next());
                    col.add(sameName);
                }
            } else if (lastChar == '$') {
                java.util.Collection targetCollection =
                    new java.util.ArrayList();
                attr.setName("name");
                getElementSetSameName(attr, null, editor, targetCollection);
                attr.setName("item");
                getElementSetSameName(attr, null, editor, targetCollection);
                getDefvarData(XI_PATH_NINJA, targetCollection);
                java.util.Iterator ite = targetCollection.iterator();
                while (ite.hasNext()) {
                    String sameName = plusData + ((String) ite.next());
                    col.add(sameName);
                }
            } else {
                col.add(plusData + " $");
                col.add(plusData + " /");
            }
        }
        attr.setName("select");
        getElementSetSameName(attr, null, editor, col);
    }

    /** The target same name attribute is substituted for col(single). */
    protected void getElementSetSameTag(
        AbstractTextEditor editor,
        java.util.Collection col) {
        //
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        try {
            int nowResult = 0;
            String findString = "<";
            FindReplaceDocumentAdapter adapter =
                new FindReplaceDocumentAdapter(document);
            while (true) {
                IRegion resion =
                    adapter.find(
                        nowResult,
                        findString,
                        true,
                        true,
                        false,
                        false);
                nowResult = resion.getOffset();
                if (nowResult < 0) {
                    return;
                }
                nowResult += findString.length();
                char ch = document.getChar(nowResult);
                if ((ch == '/')
                    || (ch == '!')
                    || (ch == '?')
                    || (ch == '%')
                    || (ch == '@')
                    || (ch == '[')) {
                    continue;
                }
                int len =
                    EE2ELispBase.get().findCharsForward(
                        nowResult,
                        " <>\t\r\n",
                        document);
                String data = document.get(nowResult, len - nowResult);
                col.add(data);
                nowResult = len + 1;
            }
        } catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException e=" + e.getMessage());
        }
    }

    protected int getLastOffset(String target, String charString) {
        if (target == null) {
            return -1;
        }
        int answer = -1;
        for (int i = 0; i < charString.length(); i++) {
            char ch = charString.charAt(i);
            for (int j = target.length() - 1; 0 <= j; j--) {
                if (target.charAt(j) == ch) {
                    if (answer < j) {
                        answer = j;
                    }
                    break;
                }
            }
        }
        return answer;
    }

    /** The target image file is substituted for col. */
    protected void getElementSetImageFile(
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {
        getElementSetFile(editor, string, col);
    }

    /** The target image file is substituted for col. */
    protected void getElementSetImageAlt(java.util.Collection col) {
        if (this.imageLength < 0) {
            setImageData();
        }
        if (this.imageLength == 0) {
            if (this.imageFileName != null) {
                col.add(this.imageFileName);
            }
            return;
        }
        String answer =
            Integer.toString(this.imageHeight)
                + "x"
                + Integer.toString(this.imageWidth)
                + "("
                + Long.toString(this.imageLength)
                + "bytes)";
        col.add(answer);
    }
    /** The target image file is substituted for col. */
    protected void getElementSetImageWidth(
        String string,
        java.util.Collection col) {
        if (this.imageLength < 0) {
            setImageData();
        }
        if (this.imageLength == 0) {
            getElementSetInteger(string, col);
            return;
        }
        String answer = Integer.toString(this.imageWidth);
        col.add(answer);
    }
    /** The target image file is substituted for col. */
    protected void getElementSetImageHeight(
        String string,
        java.util.Collection col) {
        if (this.imageLength < 0) {
            setImageData();
        }
        if (this.imageLength == 0) {
            getElementSetInteger(string, col);
            return;
        }
        String answer = Integer.toString(this.imageHeight);
        col.add(answer);
    }
    /** The target image file is substituted for col. */
    protected void getElementSetImageSdocStyle(java.util.Collection col) {
        if (this.imageLength < 0) {
            setImageData();
        }
        if (this.imageLength == 0) {
            if (this.imageFileName != null) {
                col.add(this.imageFileName);
            }
            return;
        }
        String answer =
            "width:"
                + Integer.toString(this.imageWidth)
                + ";height:"
                + Integer.toString(this.imageHeight);
        col.add(answer);
    }
    protected void getElementRevLink(java.util.Collection col) {
        getDefvarData(HTML_LINK_TYPES, col);
        col.add(META_STYLE_SHEET);
    }
    protected void getElementRelLink(java.util.Collection col) {
        String types = getMetaTypes();
        if ((types != null) && (!types.equals(""))) {
            return;
        }
        getDefvarData(HTML_LINK_TYPES, col);
        return;
    }
    protected void getElementCssStyle(java.util.Collection col) {
        String types = getMetaTypes();
        if ((types == null) || (!types.equals(META_STYLE_SHEET))) {
            return;
        }
        col.add("text/css");
    }
    protected void getElementSetMetaTypes(java.util.Collection col) {
        col.add(META_KEYWORD);
        col.add(META_AUTHER);
        col.add(META_COPYRIGHT);
        col.add(META_DATE);
        col.add(META_GENERATOR);
    }
    protected void getElementSetHttpEquiv(java.util.Collection col) {
        String types = getMetaTypes();
        if (types != null) {
            return;
        }
        col.add(META_REFRESH);
        col.add(META_CONTENT);
    }
    protected void getElementSetContent(java.util.Collection col) {
        String types = getMetaTypes();
        if (types == null) {
            return;
        }
        if (types.equals(META_KEYWORD)) {
            EE2EDebug.printf(10, "target=" + META_KEYWORD);
        } else if (types.equals(META_AUTHER)) {
            EE2EDebug.printf(10, "target=" + META_AUTHER);
        } else if (types.equals(META_COPYRIGHT)) {
            EE2EDebug.printf(10, "target=" + META_COPYRIGHT);
        } else if (types.equals(META_DATE)) {
            EE2EDebug.printf(10, "target=" + META_DATE);
            Date date = new Date();
            String dateString = DateFormat.getDateInstance().format(date);
            col.add(dateString);
        } else if (types.equals(META_GENERATOR)) {
            EE2EDebug.printf(10, "target=" + META_GENERATOR);
            col.add(GENERATOR);
        } else if (types.equals(META_REFRESH)) {
            EE2EDebug.printf(10, "target=" + META_REFRESH);
            getElementSetInteger(";URL=", col);
        } else if (types.equals(META_CONTENT)) {
            EE2EDebug.printf(10, "target=" + META_CONTENT);
            // char set Da!!
            getDefvarData(HTML_CHARSET, col);
        } else {
            EE2EDebug.printf(10, "under stand! name=" + types);
        }
    }

    /** The target ExtentionLanguage is substituted for col. */
    protected void getElementSetJspJstlEl(
        AbstractTextEditor editor,
        String string,
        java.util.Collection col) {
        int lastOffset =
            getLastOffset(string, " =$@\\/*|&()[]{}<>!\'#%~^+-,?:;");
        // not .
        String plusData;
        EE2RAttribute attr = new EE2RAttribute();
        if (lastOffset < 0) {
            return;
        }
        plusData = string.substring(0, lastOffset + 1);
        char lastChar = string.charAt(lastOffset);
        if (lastChar == '$') {
            col.add(plusData + "{");
            return;
        }
        if (lastChar == ' ') {
            java.util.Collection formulaCollection = new java.util.ArrayList();
            getDefvarData(JSP_JSPL_PATH_FORMULA, formulaCollection);
            java.util.Iterator ite = formulaCollection.iterator();
            while (ite.hasNext()) {
                String sameName = plusData + ((String) ite.next()) + " ";
                col.add(sameName);
            }
        }
        java.util.Collection targetCollection = new java.util.ArrayList();
        attr.setName("var");
        getElementSetSameName(attr, null, editor, targetCollection);
        getDefvarData(JSP_JSPL_OBJECT, targetCollection);
        java.util.Iterator ite = targetCollection.iterator();
        while (ite.hasNext()) {
            String sameName = plusData + ((String) ite.next());
            col.add(sameName);
        }
        targetCollection.clear();
        attr.setName("varSource");
        getElementSetSameName(attr, null, editor, targetCollection);
        if (targetCollection.size() <= 0) {
            return;
        }
        java.util.Collection varSourceCollection = new java.util.ArrayList();
        getDefvarData(JSP_JSPL_VAR_SOURCE, varSourceCollection);
        ite = targetCollection.iterator();
        while (ite.hasNext()) {
            String sameName = plusData + ((String) ite.next());
            java.util.Iterator varSourceIte = varSourceCollection.iterator();
            while (varSourceIte.hasNext()) {
                String varSource = sameName + ((String) varSourceIte.next());
                col.add(varSource);
            }
        }
    }

    protected void getDefvarData(String string, java.util.Collection col) {
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(string);
        for (int i = 0; i < defvar.getContentCount(); i++) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if (!(choice instanceof EE2REnumeration)) {
                continue;
            }
            EE2REnumeration emu = (EE2REnumeration) choice;
            col.add(emu.getName());
        }
    }
    protected String getMetaTypes() {
        String metaTypes = null;
        for (int i = 0;(i < this.argList.size()) && (metaTypes == null); i++) {
            EE2RAttribute attribute =
                EE2EToolkit.get().getAttribute(this.nextTag, i);
            for (int j = 0;
                (j < attribute.getEnumerationCount()) && (metaTypes == null);
                j++) {
                EE2REnumeration enum = attribute.getEnumeration(j);
                if ((enum.getRef() != null)
                    && ((enum.getRef().equals(HTML_SET_META_TYPES))
                        || (enum.getRef().equals(HTML_SET_REV_LINK))
                        || (enum.getRef().equals(HTML_SET_REL_LINK))
                        || (enum.getRef().equals(HTML_SET_HTTP_EQUIV)))) {
                    String buff = (String) this.argList.get(i);
                    if ((buff != null) && (!buff.equals(""))) {
                        metaTypes = buff;
                    }
                }
            }
        }
        return metaTypes;
    }
    protected boolean setImageData() {
        this.imageLength = 0; // -1 status clear.
        String fileName = null;
        for (int i = 0;(i < this.argList.size()) && (fileName == null); i++) {
            EE2RAttribute attribute =
                EE2EToolkit.get().getAttribute(this.nextTag, i);
            for (int j = 0;
                (j < attribute.getEnumerationCount()) && (fileName == null);
                j++) {
                EE2REnumeration enum = attribute.getEnumeration(j);
                if ((enum.getRef() != null)
                    && (enum.getRef().equals(HTML_IMAGE_FILE_NAME))) {
                    fileName = (String) this.argList.get(i);
                }
            }
        }
        if (fileName == null) {
            return false;
        }
        java.io.File targetParent = new java.io.File(fileName);
        java.io.File target = getTargetFile(editorIns, fileName, targetParent);
        if (target == null) {
            return false;
        }
        if (!target.isFile()) {
            return false;
        }
        this.imageLength = target.length();
        java.awt.Frame doutFrame = new java.awt.Frame();
        try {
            java.awt.Image image =
                java.awt.Toolkit.getDefaultToolkit().getImage(target.toURL());
            java.awt.MediaTracker mediatracker =
                new java.awt.MediaTracker(doutFrame);
            mediatracker.addImage(image, 0);
            mediatracker.waitForID(0);
            this.imageHeight = image.getHeight(doutFrame);
            this.imageWidth = image.getWidth(doutFrame);
        } catch (MalformedURLException e) {
            doutFrame.dispose();
            return false;
        } catch (InterruptedException e) {
            doutFrame.dispose();
            return false;
        }
        doutFrame.dispose();
        return true;
    }

    protected void checkTagExtFlag(EE2RStructureList structureList) {
        IDocument document = EE2EToolkit.get().getEditorToDocument(this.editorIns);
        if (document == null) {
            return;
        }
        try {
            FindReplaceDocumentAdapter adapter =
                new FindReplaceDocumentAdapter(document);
            for (int i = 0; i < structureList.getTagextCount(); i++) {
                EE2RTagext tagext = structureList.getTagext(i);
                if (tagext == null) {
                    continue;
                }
                IRegion resion =
                    adapter.find(
                        0,
                        tagext.getTarget(),
                        true,
                        true,
                        false,
                        false);
                if (resion.getOffset() < 0) {
                    continue;
                }
                String tagref = tagext.getTagref();
                addTagextToDefvar(structureList, tagref);
                structureList.setTagext(i, null);
            }
        } catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException e" + e.getMessage());
        }
    }

    private void addTagextToDefvar(
        EE2RStructureList structureList,
        String tagref) {
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(structureList);
        if (defvar == null) {
            return;
        }
        EE2RDefvar targetDefvar = EE2EToolkit.get().getDefvar(tagref);
        java.util.List list = new java.util.LinkedList();
        for (int i = 0; i < defvar.getContentCount(); i++) {
            list.add(defvar.getContent(i));
        }
        for (int i = 0; i < targetDefvar.getContentCount(); i++) {
            list.add(targetDefvar.getContent(i));
        }
        defvar.setContent(
            (IEE2RDefvarChoice[]) list.toArray(new IEE2RDefvarChoice[0]));
    }

    /** initialization method */
    protected void initialize() {
        EE2EDebug.printf(3, "initialize");
        //this.structureListRef = null;
        this.defvarIns = null;
        this.nextTag = null;
        this.nextAttribute = null;
        this.editorIns = null;
        this.tagCompletent = null;
        this.argList = null;
        this.imageFileName = null;
        this.imageLength = -1;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.tagExtFlag = false;
    }
    //
    private EE2RStructureList strListIns;
    private EE2EIndentBehavior indentBehavior;
    private String oneString;
    //
    private EE2RDefvar defvarIns;
    private EE2RTag nextTag;
    private EE2RAttribute nextAttribute;
    private AbstractTextEditor editorIns;
    private String tagCompletent;
    private java.util.LinkedList argList;
    //
    private String imageFileName;
    private long imageLength;
    private int imageWidth;
    private int imageHeight;
    //
    private boolean tagExtFlag;
}
