package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public interface EE2EMenuBehavior {
    /**
     * The character displayed on a menu bar
     * @return The character displayed on a menu bar
     */
    String getText();

    /**
     * The character displayed on a tooltip
     * @return The character displayed on a tooltip
     */
    String getToolTipText();

    /**
     * Behavior of action is described.
     * @param editor An editor active now
     * @param document Document
     * @param The position of cursor
     */
    void doBehavior(
        AbstractTextEditor editor,
        IDocument document,
        ITextSelection textSelection)
        throws BadLocationException;
}
