package jp.sourceforge.projects.ee2e.core.ttledit;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.relax.*;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;

import java.util.*;
import org.eclipse.jface.text.rules.*;
import org.eclipse.jface.text.*;

public class TtlScanner extends RuleBasedScanner {
    public static final String TARGET = "ttl";
    public static final String KEYWORDS = "ttl-kywords-table";
    public static final String TYPES = "ttl-types-table";
    public static final String CONSTANTS = "ttl-constants-table";
  
	/**
	 * Creates a Java code scanner
	 */
	public TtlScanner(TtlColorProvider provider) {

		IToken keyword= new Token(new TextAttribute(provider.getColor(TtlColorProvider.KEYWORD)));
		IToken type= new Token(new TextAttribute(provider.getColor(TtlColorProvider.TYPE)));
		IToken constants= new Token(new TextAttribute(provider.getColor(TtlColorProvider.CONSTANTS)));
		IToken string= new Token(new TextAttribute(provider.getColor(TtlColorProvider.STRING)));
		IToken comment= new Token(new TextAttribute(provider.getColor(TtlColorProvider.SINGLE_LINE_COMMENT)));
		IToken other= new Token(new TextAttribute(provider.getColor(TtlColorProvider.DEFAULT)));

		List rules= new ArrayList();

		// Add rule for single line comments.
		rules.add(new EndOfLineRule(";", comment)); //$NON-NLS-1$

		// Add rule for strings and character constants.
		rules.add(new SingleLineRule("\"", "\"", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$
		rules.add(new SingleLineRule("'", "'", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

		// Add generic whitespace rule.
		rules.add(new WhitespaceRule(new TtlWhitespaceDetector()));

		// Add word rule for keywords, types, and constants.
		WordRule wordRule= new WordRule(new TtlWordDetector(), other);
		this.getDefvarData(wordRule,KEYWORDS,keyword);
		this.getDefvarData(wordRule,TYPES,type);
		this.getDefvarData(wordRule,CONSTANTS,constants);
		rules.add(wordRule);

		IRule[] result= new IRule[rules.size()];
		rules.toArray(result);
		setRules(result);
	}
    protected void getDefvarData(WordRule wordRule,String string,IToken token) {
		EE2REe2e ee2e = EE2EToolkit.get().getEe2e(TARGET);
		if (ee2e == null) {
			EE2EDebug.printf(1, "getDefvarData/ee2e is null");
			return;
		}
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(string);
        if(defvar == null) {
			EE2EDebug.printf(1, "getDefvarData/defvar is null");
        	return;
        }
        for(int i = 0 ; i < defvar.getContentCount() ; i++) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if(! (choice instanceof EE2RTag) ) {
                continue;
            }
            EE2RTag tag = (EE2RTag) choice;
            wordRule.addWord(tag.getName(),token);
        }
	}
}
