package jp.sourceforge.projects.ee2e.core.typeset;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.jface.text.IDocument;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EDerivationResource extends EE2EFileJump {
    public EE2EDerivationResource(String derivationResource) {
        this.derivationResource = derivationResource;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.typeset.derivation")
            + "(&r)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString(
            "action.typeset.derivation.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.typeset.EE2EFileJump#doAction(ITextSelection, IFileEditorInput, IWorkbenchPage)
     */
    protected void doAction(
        ITextSelection textSelection,
        IFileEditorInput fileInput,
        IDocument document,
        IWorkbenchPage page)
        throws BadLocationException, PartInitException {
        IFile iFile = fileInput.getFile();
        IPath path = iFile.getLocation();
        path = path.removeFileExtension();
        //
        IPath appendPath = path.addFileExtension(derivationResource);
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        IFile anserFile = iWorkspaceRoot.getFileForLocation(appendPath);
        if ((anserFile == null) || (!anserFile.exists())) {
            throw new PartInitException(
                "File not found (" + appendPath.toFile().toString() + ")");
        }
        this.openEditor(anserFile, page);
    }

    private String derivationResource;
}