/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2ECommentRegion
implements EE2EMenuBehavior {
    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.commentR")) + "(&>)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.commentR.tooltip");
    }

    public void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        String text = textSelection.getText();
        if (textSelection.getLength() <= 0 && text.equals("")) {
            return;
        }
        StringReader sReader = new StringReader(text);
        BufferedReader bReader = new BufferedReader(sReader);
        StringWriter sWriter = new StringWriter();
        try {
            String line;
            while ((line = bReader.readLine()) != null) {
                sWriter.write("<!--");
                sWriter.write(line);
                sWriter.write("-->");
                sWriter.write("\n");
            }
            bReader.close();
            sWriter.close();
            document.replace(textSelection.getOffset(), textSelection.getLength(), sWriter.toString());
        }
        catch (IOException e) {
            EE2EDebug.printf(10, "IOException e=" + e.getMessage());
        }
    }
}

