package jp.sourceforge.projects.ee2e.core.scratch;
import jp.sourceforge.projects.ee2e.core.*;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.*;
import org.eclipse.ui.*;
import org.eclipse.swt.SWT;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.action.*;
import org.eclipse.ui.ide.IDE;

/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class EE2EWindowsView extends ViewPart {
	/**
	 * Creates a content outline view with no content outline pages.
	 */
	public EE2EWindowsView() {
		super();
	}
	public void setFocus() {
		this.text[this.tableFolder.getSelectionIndex()].setFocus();
	}
    private static final int MAX = 10;
	public void createPartControl(Composite parent) {
		this.setPartName("Windows");

		this.text = new Text[MAX];
        this.tableFolder = new TabFolder(parent,SWT.NONE);
        for(int i = 0 ; i < this.text.length ; i++) {
            this.text[i] = new Text(this.tableFolder, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
        }
		//
		Action clearAction =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_DELETE)) {
			public void run() {
				doDeleteAction();
			}
		};
		clearAction.setImageDescriptor(
			PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
				ISharedImages.IMG_OBJS_WARN_TSK));
		//
		Action fileJump =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_EDITOR)) {
			public void run() {
				EE2EFileJumpAction action = new EE2EFileJumpAction();
                action.init(EE2EWindowsView.this);
                action.run(this);
			}
		};
		fileJump.setImageDescriptor(
			PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
				ISharedImages.IMG_OBJ_FILE));
		//
		Action fileSystemJump =
			new Action(
				EE2EPlugin.getResourceString(EE2EPlugin.P_MESSAGE_SYSTEM)) {
			public void run() {
				EE2EFileSystemJumpAction action = new EE2EFileSystemJumpAction();
                action.init(EE2EWindowsView.this);
                action.run(this);
			}
		};
		fileSystemJump.setImageDescriptor(
			PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
				IDE.SharedImages.IMG_OBJS_TASK_TSK));
		//
		//
		IActionBars bars = getViewSite().getActionBars();
		IMenuManager manager = bars.getMenuManager();
		//
		IToolBarManager toolBarManager =
			getViewSite().getActionBars().getToolBarManager();
		//
		toolBarManager.add(fileJump);
		manager.add(fileJump);
		toolBarManager.add(fileSystemJump);
		manager.add(fileSystemJump);
		toolBarManager.add(clearAction);
		manager.add(clearAction);
	}
	protected void doDeleteAction() {
		this.text[this.tableFolder.getSelectionIndex()].setText("");
	}
    private TabFolder tableFolder;
	private Text [] text;
}