/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.scratch.EE2EScratchView;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2ECopyScratch
implements EE2EMenuBehavior {
    public static final String VIEW_TARGET = "jp.sourceforge.projects.ee2e.core.scratch.EE2EScratchView";

    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.copy")) + "(&o)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.copy.tooltip");
    }

    public void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        IViewPart veiwPart;
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IWorkbench bentch = plugin.getWorkbench();
        if (bentch == null) {
            return;
        }
        IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            veiwPart = page.showView(VIEW_TARGET);
        }
        catch (PartInitException partInitException) {
            return;
        }
        if (!(veiwPart instanceof EE2EScratchView)) {
            return;
        }
        EE2EScratchView scratchView = (EE2EScratchView)veiwPart;
        scratchView.deleteAll();
        scratchView.append(document.get());
        int offset = textSelection.getOffset() + textSelection.getStartLine();
        int length = textSelection.getLength() - textSelection.getStartLine() + textSelection.getEndLine();
        scratchView.setOffset(offset, offset + length);
    }
}

