package jp.sourceforge.projects.ee2e.core.cdt;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EIndentJava;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentCppFormat extends EE2EIndentJava {

    /** constractor */
    public EE2EIndentCppFormat(int indentSize) {
        super(indentSize);
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public final String getText() {
        return EE2EPlugin.getResourceString("action.c.format");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public final String getToolTipText() {
        return EE2EPlugin.getResourceString("action.c.format.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    protected void doIndent(int offset, IDocument document)
        throws BadLocationException {
        for (int i = 0; i < document.getNumberOfLines(); i++) {
            try {
                int nextOffset = document.getLineOffset(i);
                super.doIndent(nextOffset, document);
            } catch (BadLocationException be) {
                EE2EDebug.printf(
                    3,
                    "BadLocationException!! line=" + i + " " + be.getMessage());
            }
        }
    }
}
