package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RIteration</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="iteration">
 *   <tag>
 *     <attribute name="opener" type="string"/>
 *     <attribute name="closer" type="string"/>
 *     <attribute name="require" type="string"/>
 *   </tag>
 *   <sequence>
 *     <ref label="structure" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="iteration"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="opener" type="string"/&gt;
 *     &lt;attribute name="closer" type="string"/&gt;
 *     &lt;attribute name="require" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="structure" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RIteration implements java.io.Serializable {
    private String opener_;
    private String closer_;
    private String require_;
    // List<EE2RStructure>
    private java.util.List structure_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RIteration</code>.
     *
     */
    public EE2RIteration() {
    }

    /**
     * Creates a <code>EE2RIteration</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RIteration(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RIteration(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RIteration</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RIteration(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RIteration</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RIteration</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIteration(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        opener_ = URelaxer.getAttributePropertyAsString(element, "opener");
        closer_ = URelaxer.getAttributePropertyAsString(element, "closer");
        require_ = URelaxer.getAttributePropertyAsString(element, "require");
        structure_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RStructure.isMatch(stack)) {
                addStructure(new EE2RStructure(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("iteration");
        int size;
        if (this.opener_ != null) {
            URelaxer.setAttributePropertyByString(element, "opener", this.opener_);
        }
        if (this.closer_ != null) {
            URelaxer.setAttributePropertyByString(element, "closer", this.closer_);
        }
        if (this.require_ != null) {
            URelaxer.setAttributePropertyByString(element, "require", this.require_);
        }
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RIteration</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RIteration</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>opener</b>.
     *
     * @return String
     */
    public final String getOpener() {
        return (opener_);
    }

    /**
     * Sets the String property <b>opener</b>.
     *
     * @param opener
     */
    public final void setOpener(String opener) {
        this.opener_ = opener;
    }

    /**
     * Gets the String property <b>closer</b>.
     *
     * @return String
     */
    public final String getCloser() {
        return (closer_);
    }

    /**
     * Sets the String property <b>closer</b>.
     *
     * @param closer
     */
    public final void setCloser(String closer) {
        this.closer_ = closer;
    }

    /**
     * Gets the String property <b>require</b>.
     *
     * @return String
     */
    public final String getRequire() {
        return (require_);
    }

    /**
     * Sets the String property <b>require</b>.
     *
     * @param require
     */
    public final void setRequire(String require) {
        this.require_ = require;
    }

    /**
     * Gets the EE2RStructure property <b>structure</b>.
     *
     * @return EE2RStructure[]
     */
    public final EE2RStructure[] getStructure() {
        EE2RStructure[] array = new EE2RStructure[structure_.size()];
        return ((EE2RStructure[])structure_.toArray(array));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void setStructure(EE2RStructure[] structure) {
        this.structure_.clear();
        this.structure_.addAll(java.util.Arrays.asList(structure));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void setStructure(EE2RStructure structure) {
        this.structure_.clear();
        this.structure_.add(structure);
    }

    /**
     * Adds the EE2RStructure property <b>structure</b>.
     *
     * @param structure
     */
    public final void addStructure(EE2RStructure structure) {
        this.structure_.add(structure);
    }

    /**
     * Gets number of the EE2RStructure property <b>structure</b>.
     *
     * @return int
     */
    public final int getStructureCount() {
        return (structure_.size());
    }

    /**
     * Gets the EE2RStructure property <b>structure</b> by index.
     *
     * @param index
     * @return EE2RStructure
     */
    public final EE2RStructure getStructure(int index) {
        return ((EE2RStructure)structure_.get(index));
    }

    /**
     * Sets the EE2RStructure property <b>structure</b> by index.
     *
     * @param index
     * @param structure
     */
    public final void setStructure(int index, EE2RStructure structure) {
        this.structure_.set(index, structure);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<iteration");
        if (opener_ != null) {
            buffer.append(" opener=\"");
            buffer.append(URelaxer.escapeAttrQuot(getOpener()));
            buffer.append("\"");
        }
        if (closer_ != null) {
            buffer.append(" closer=\"");
            buffer.append(URelaxer.escapeAttrQuot(getCloser()));
            buffer.append("\"");
        }
        if (require_ != null) {
            buffer.append(" require=\"");
            buffer.append(URelaxer.escapeAttrQuot(getRequire()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</iteration>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<iteration");
        if (opener_ != null) {
            buffer.print(" opener=\"");
            buffer.print(URelaxer.escapeAttrQuot(getOpener()));
            buffer.print("\"");
        }
        if (closer_ != null) {
            buffer.print(" closer=\"");
            buffer.print(URelaxer.escapeAttrQuot(getCloser()));
            buffer.print("\"");
        }
        if (require_ != null) {
            buffer.print(" require=\"");
            buffer.print(URelaxer.escapeAttrQuot(getRequire()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.structure_.size();
        for (int i = 0;i < size;i++) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</iteration>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RIteration</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "iteration")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RStructure.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RIteration</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RIteration</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
