/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.projects.ee2e.core.indent.EE2ECppDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2ECppString;

public class EE2ECppSharp
implements EE2ECppDocument {
    public static final int NONE = 0;
    public static final int IF_DEF = 1;
    public static final int IF_NDEF = 2;
    public static final int ELSE = 3;
    public static final int ELSE_IF = 4;
    public static final int END_IF = 5;
    private String myString;
    private List list;
    private EE2ECppSharp nextSharp;

    public EE2ECppSharp(String myString) {
        this.myString = myString;
        this.list = null;
        this.nextSharp = null;
    }

    public boolean createComposit(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return false;
        }
        this.list = null;
        this.nextSharp = null;
        while ((line = reader.readLine()) != null) {
            EE2ECppDocument document;
            int answer = this.checkSharp(line);
            if (answer == 1 || answer == 2) {
                document = new EE2ECppSharp(line);
                if (this.list == null) {
                    this.list = new LinkedList();
                }
                this.list.add(document);
            } else {
                if (answer == 3 || answer == 4) {
                    this.nextSharp = new EE2ECppSharp(line);
                    return this.nextSharp.createComposit(reader);
                }
                if (answer == 5) {
                    return true;
                }
                document = new EE2ECppString(line);
                if (this.list == null) {
                    this.list = new LinkedList();
                }
                this.list.add(document);
            }
            if (document.createComposit(reader)) continue;
            break;
        }
        return false;
    }

    public void destoryTarget(String target, boolean ifOrElse) {
        String myTargetString;
        if (target == null) {
            return;
        }
        if (this.list != null) {
            Iterator ite = this.list.iterator();
            while (ite.hasNext()) {
                EE2ECppDocument document = (EE2ECppDocument)ite.next();
                document.destoryTarget(target, ifOrElse);
            }
        }
        if (this.nextSharp != null) {
            this.nextSharp.destoryTarget(target, ifOrElse);
        }
        if ((myTargetString = this.devideSharp(this.myString)) != null && myTargetString.equals(target)) {
            int state = this.checkSharp(this.myString);
            this.myString = "";
            if (ifOrElse && (state == 1 || state == 4) || !ifOrElse && (state == 2 || state == 3)) {
                this.list = null;
            } else {
                this.nextSharp = null;
            }
        }
    }

    public void getWriter(Writer writer, boolean flag) throws IOException {
        if (writer == null) {
            return;
        }
        int answer = this.checkSharp(this.myString);
        boolean firstFlag = false;
        if (answer == 1 || answer == 2) {
            firstFlag = true;
            writer.write(this.myString);
            writer.write("\n");
        } else if (answer == 3) {
            if (flag) {
                writer.write(this.myString);
                writer.write("\n");
            }
        } else if (answer == 4) {
            if (flag) {
                writer.write(this.myString);
                writer.write("\n");
            } else {
                writer.write("#if ");
                writer.write(this.devideSharp(this.myString));
                writer.write("\n");
                firstFlag = true;
            }
        }
        if (this.list != null) {
            Iterator ite = this.list.iterator();
            while (ite.hasNext()) {
                EE2ECppDocument doc = (EE2ECppDocument)ite.next();
                doc.getWriter(writer, false);
            }
        }
        if (this.nextSharp != null) {
            this.nextSharp.getWriter(writer, firstFlag | flag);
        }
        if (firstFlag) {
            writer.write("#endif\n");
        }
    }

    public void getDefines(Collection collection) {
        String res = this.devideSharp(this.myString);
        if (res != null && !res.equals("")) {
            collection.add(res);
        }
        if (this.list != null) {
            Iterator ite = this.list.iterator();
            while (ite.hasNext()) {
                EE2ECppDocument doc = (EE2ECppDocument)ite.next();
                doc.getDefines(collection);
            }
        }
        if (this.nextSharp != null) {
            this.nextSharp.getDefines(collection);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String devideSharp(String line) {
        answer = this.checkSharp(line);
        if (answer == 0 || answer == 5) {
            return null;
        }
        if ((line = this.deleteSpace(line)) != null) ** GOTO lbl8
        return null;
        while (line.charAt(0) != ' ') {
            line = line.substring(1);
lbl8:
            // 2 sources

            if (line.length() > 0) continue;
        }
        if (line.length() > 0 && line.charAt(0) == ' ') {
            line = line.substring(1);
        }
        return line;
    }

    protected int checkSharp(String line) {
        if ((line = this.deleteSpace(line)) == null) {
            return 0;
        }
        if (line.indexOf("#ifndef") == 0) {
            return 2;
        }
        if (line.indexOf("#ifdef") == 0) {
            return 1;
        }
        if (line.indexOf("#elseif") == 0) {
            return 4;
        }
        if (line.indexOf("#elsif") == 0) {
            return 4;
        }
        if (line.indexOf("#elif") == 0) {
            return 4;
        }
        if (line.indexOf("#else") == 0) {
            return 3;
        }
        if (line.indexOf("#endif") == 0) {
            return 5;
        }
        if (line.indexOf("#end") == 0) {
            return 5;
        }
        if (line.indexOf("#if") == 0) {
            return 1;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected String deleteSpace(String line) {
        block9: {
            block8: {
                if (line == null) {
                    return null;
                }
                line = EE2ECppSharp.deleteSpaceAndComment(line);
                while ((index = line.indexOf("\t")) >= 0) {
                    line = String.valueOf(line.substring(0, index)) + " " + line.substring(index + 1);
                }
                while ((index = line.indexOf("\r")) >= 0) {
                    line = String.valueOf(line.substring(0, index)) + " " + line.substring(index + 1);
                }
                while ((index = line.indexOf("\n")) >= 0) {
                    line = String.valueOf(line.substring(0, index)) + " " + line.substring(index + 1);
                }
                break block8;
lbl14:
                // 1 sources

                while ((index = line.indexOf("  ")) >= 0) {
                    line = String.valueOf(line.substring(0, index + 1)) + line.substring(index + 2);
                    break block8;
                }
                break block9;
            }
            if (3 < line.length()) ** GOTO lbl14
        }
        if (3 < line.length() && line.charAt(0) == ' ') {
            line = line.substring(1);
        }
        if ((index = line.indexOf("# ")) > 0) {
            line = String.valueOf(line.substring(0, index)) + line.substring(index + 2);
        }
        if (line.length() <= 0 || line.charAt(0) != '#') {
            return null;
        }
        return line;
    }

    protected String getMyString() {
        return this.myString;
    }

    protected List getList() {
        return this.list;
    }

    protected EE2ECppSharp getSharp() {
        return this.nextSharp;
    }

    public static String deleteSpaceAndComment(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        int index = line.indexOf("//");
        if (index >= 0) {
            line = line.substring(0, index);
        }
        while (true) {
            int leftIndex = line.indexOf("/*");
            int rightIndex = line.indexOf("*/");
            if (leftIndex < 0 || rightIndex <= leftIndex) break;
            line = String.valueOf(line.substring(0, leftIndex)) + line.substring(rightIndex + 2);
        }
        while (line.length() > 0 && (line.charAt(line.length() - 1) == ' ' || line.charAt(line.length() - 1) == '\r' || line.charAt(line.length() - 1) == '\t' || line.charAt(line.length() - 1) == '\n')) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }
}

