package jp.sourceforge.projects.ee2e.core.indent;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJava implements EE2EIndentAction {
    /** constractor */
    public EE2EIndentJava(int indentLen,boolean isRedundantCircleFlag) {
        //
        this.indentLen = indentLen;
        this.isRedundantCircleFlag = isRedundantCircleFlag;
    }
    private boolean isRedundantCircleFlag;
    
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, EE2EDocument, ITextSelection)
     */
    public void doIndent(int argumentOffset, EE2EDocument document)
        throws EE2EIndentException {
        //
        int offset =
            EE2ELispBase.get().beginningOfLine(argumentOffset, document);

        // 擪 #n܂indent 0
        if (this.doSharpSheck(offset, document)) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }

        /* "javadoc" indent check! */
        int len;
        int ans = checkDocument(offset, document);
        if (0 <= ans) {
            len = ans;
            if (!isMyLineDocument(offset, document)) {
                EE2ELispBase.get().indentTo(offset, len, document);
            }
            EE2ELispBase.get().indentTo(offset, len + 1, document);
            return;
        }
        if (this.isRedundantCircleFlag) {
            ans = checkCercle(offset, document);
            if (0 <= ans) {
                len = ans;
                EE2ELispBase.get().indentTo(offset, len, document);
                return;
            }
        }

        // Ocharʒu擾
        // 擪s̈O̕猟̂ offset - 1
        int oneBefore = getPrependChar(offset - 1, document, 0);
        if (oneBefore <= 0) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }

        len = 0;

        // O char  ',' ł
        char targetChar = document.getChar(oneBefore);
        if (targetChar == ',') {
            // ; O = ꂽ = ̂ʒu + 4 Cfg
            int com = EE2ELispBase.get().findCharsBackward(offset, ";", document);
            int eq = EE2ELispBase.get().findCharsBackward(offset, "=", document);
            if (com < eq) {
                len = EE2ELispBase.get().indentLen(eq,document);
                len += this.indentLen;
                EE2ELispBase.get().indentTo(offset, len, document);
                return;
            }
        }
        
        // Ochar ';'  '}' łȂ + 4
        if ((targetChar != ';') && (targetChar != '}')) {
            len += this.indentLen;
        }

        // target line  ':' ŏI -4
        int lastOffset = EE2ELispBase.get().endOfLine(offset, document);
        lastOffset = getPrependChar(lastOffset + 1, document, offset);
        if (0 <= lastOffset) {
            targetChar = document.getChar(lastOffset);
            if (targetChar == ':') {
                len -= this.indentLen;
            }
        }

        // target line  '}' Ŏn܂ -4
        int firstOffset =
            EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1;
        if (firstOffset < document.getLength()) {
            targetChar = document.getChar(firstOffset);
            if ((targetChar == '}')
                || (targetChar == ']')
                || (targetChar == ')')) {
                len -= this.indentLen;
            }
        }

        // get base line offset.
        int baseLineOffset = this.getBaseLineOffset(oneBefore, document);
        len += baseLineOffset;

        // compact circle.
        if (len < 0) {
            len = 0;
        }
        EE2ELispBase.get().indentTo(offset, len, document);
    }
    protected int getBaseLineOffset(int offset, EE2EDocument document)
        throws EE2EIndentException {
        int baseLineOffset =
            EE2ELispBase.get().beginningOfLine(offset, document);
        int oneBefore = offset;
        char targetChar;
        boolean flag = false;
        while (0 <= baseLineOffset) {
            oneBefore = this.getPrependChar(oneBefore - 1, document, 0);
            if (oneBefore < 0) {
                break;
            }
            if (!flag) {
                targetChar = document.getChar(oneBefore);
                if ((targetChar == ';')
                    || (targetChar == ':')
                    || (targetChar == '{')
                    || (targetChar == '}')) {
                    flag = true;
                }
            }
            if (flag) {
                if (this.isNotInTheCircle(baseLineOffset, offset, document)) {
                    break;
                }
            }
            baseLineOffset = oneBefore;
            oneBefore = EE2ELispBase.get().beginningOfLine(oneBefore, document);
        }
        return EE2ELispBase.get().indentLen(baseLineOffset, document);
    }
    protected boolean isNotInTheCircle(
        int oneBefore,
        int end,
        EE2EDocument document)
        throws EE2EIndentException {
        int start = EE2ELispBase.get().beginningOfLine(oneBefore, document);
        int pos = 0;
        boolean toriger = false;
        for (int offset = start; offset <= end; offset++) {
            if (this.isQuoteTorigerCountCheck(offset, document)) {
                if (toriger) {
                    toriger = false;
                } else {
                    toriger = true;
                }
            }
            if (toriger) {
                continue;
            }
            char targetChar = document.getChar(offset);
            if ((targetChar == ')') || (targetChar == ']')) {
                pos++;
            } else if ((targetChar == '(') || (targetChar == '[')) {
                pos--;
            }
        }
        return pos <= 0;
    }

    /** hLgłƓ삷 */
    protected int checkDocument(int offset, EE2EDocument document)
        throws EE2EIndentException {
        if (offset < 2) {
            return -1;
        }
        for (int i = offset - 2; 1 <= i; i--) {
            char ch1 = document.getChar(i - 1);
            char ch2 = document.getChar(i);
            if ((ch1 == '*') && (ch2 == '/')) {
                return -1;
            }
            if ((ch1 == '/') && (ch2 == '*')) {
                int ans = EE2ELispBase.get().indentLen(i, document);
                return ans;
            }
        }
        return -1;
    }

    protected boolean isMyLineDocument(int offset, EE2EDocument document)
        throws EE2EIndentException {
        int start = EE2ELispBase.get().beginningOfLine(offset, document);
        int next = EE2ELispBase.get().skipCharsForward(start, " \t", document);
        next++;
        if (document.getLength() <= next) {
            return false;
        }
        char ch = document.getChar(next);
        if (ch == '*') {
            return true;
        }
        return false;
    }

    /** #Ŏn܂sł true */
    private boolean doSharpSheck(int offset, EE2EDocument document)
        throws EE2EIndentException {
        int next =
            EE2ELispBase.get().skipCharsForward(offset, " \t\r\n", document);
        next++;
        if (document.getLength() <= next) {
            return false;
        }
        char target = document.getChar(next);
        if (target == '#') {
            return true;
        }
        return false;
    }

    /** RgXLbvẴItZbglԂ */
    private int doCommentSkipOffset(int offset, EE2EDocument document)
        throws EE2EIndentException {
        int before = offset - 1;
        if (document.getLength() <= offset) {
            return offset;
        }
        for (int nowOffset = before; 0 <= nowOffset; nowOffset--) {
            char ch1;
            char ch2;
            ch1 = document.getChar(nowOffset);
            ch2 = document.getChar(nowOffset + 1);
            if ((ch1 == '*') && (ch2 == '/')) {
                return offset;
            } else if ((ch1 == '/') && (ch2 == '*')) {
                return nowOffset;
            }
        }
        return offset;
    }

    /** O̎擾 */
    protected int getPrependChar(int offset, EE2EDocument document, int min)
        throws EE2EIndentException {
        int oneBefore = offset;
        int target = -1;
        boolean commentTriger = false;
        while ((min < oneBefore) && (target < 0)) {
            oneBefore = this.doCommentSkipOffset(oneBefore, document);
            if (document.getLength() <= oneBefore) {
                return document.getLength() - 1;
            }
            boolean toriger = false;
            for (int commentOffset =
                EE2ELispBase.get().beginningOfLine(oneBefore, document);
                commentOffset < oneBefore + 1;
                commentOffset++) {
                char ch = document.getChar(commentOffset);
                if (ch == '#') {
                    toriger = true;
                }
                if ((ch != ' ')
                    && (ch != '\t')
                    && (ch != '\r')
                    && (ch != '\n')) {
                    break;
                }
            }
            if (toriger) {
                oneBefore =
                    EE2ELispBase.get().beginningOfLine(oneBefore, document);
                oneBefore--;
                continue;
            }
            toriger = false;
            boolean charTriger = false;
            int begin = EE2ELispBase.get().beginningOfLine(oneBefore, document);
            for (int commentOffset = oneBefore;
                begin <= commentOffset;
                commentOffset--) {
                if (this.isQuoteTorigerCountCheck(commentOffset, document)) {
                    toriger = !toriger;
                }
                if (toriger) {
                    continue;
                }
                char ch = document.getChar(commentOffset);
                char ch2 = (char) 0;
                if ((commentOffset + 1) < document.getLength()) {
                    ch2 = document.getChar(commentOffset + 1);
                }
                if (((ch == '/') && (ch2 == '*'))) {
                    commentTriger = false;
                    continue;
                }
                if (commentTriger) {
                    continue;
                }
                if (((ch == '*') && (ch2 == '/'))) {
                    if((target - 1) == commentOffset) {
                        target = -1;
                        charTriger = false;
                    }
                    commentTriger = true;
                    continue;
                }
                if (((ch == '/') && (ch2 == '/'))) {
                    target = -1;
                    charTriger = false;
                    continue;
                }
                if ((!charTriger)
                    && (ch != ' ')
                    && (ch != '\t')
                    && (ch != '\r')
                    && (ch != '\n')
                    && (ch != '\\')) { // C MACRO
                    target = commentOffset;
                    charTriger = true;
                }
            }
            if (0 <= target) {
                break;
            }
            oneBefore = EE2ELispBase.get().beginningOfLine(oneBefore, document);
            oneBefore--;
        }
        return target;
    }
    protected int checkCercle(int argOffset, EE2EDocument document)
        throws EE2EIndentException {
        int ans = -1;
        int pos = 0;
        boolean toriger = false;
        for (int offset = argOffset; 0 <= offset; offset--) {
            if (this.isQuoteTorigerCountCheck(offset, document)) {
                if (toriger) {
                    toriger = false;
                } else {
                    toriger = true;
                }
            }
            if (toriger) {
                continue;
            }
            char ch = document.getChar(offset);
            if ((ch == '{') || (ch == '}')) {
                break;
            }
            if ((ch == ')') || (ch == ']')) {
                pos++;
                continue;
            }
            if ((ch == '(') || (ch == '[')) {
                pos--;
                if (pos < 0) {
                    int start =
                        EE2ELispBase.get().beginningOfLine(offset, document);
                    ans = offset - start + 1;
                    break;
                }
                continue;
            }
        }
        return ans;
    }

    /**  1CsQuote̐Ȃ`FbNȂ  */
    protected boolean isQuoteTorigerCountCheck(int offset, EE2EDocument document)
        throws EE2EIndentException {
        boolean ans = isQuoteToriger(offset,document);
        int lineOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        int endLineOffset = EE2ELispBase.get().endOfLine(lineOffset, document);
        int count = 0;
        if (!ans) {
            return ans;
        }
        for (;lineOffset < endLineOffset ; lineOffset++) {
            if (this.isQuoteToriger(lineOffset,document)) {
                count++;
            }
        }
        if ((count % 2) != 0) {
            return false;
        }
        return true;
    }

    /**  /[\\\\]*;/   */
    protected boolean isQuoteToriger(int offset, EE2EDocument document)
        throws EE2EIndentException {
        if ((offset < 0) || (document.getLength() <= offset)) {
            return false;
        }
        char ch = document.getChar(offset);
        boolean ans = (ch == '\'') || (ch == '\"');
        if (!ans) {
            return false;
        }
        int count = 0;
        offset--;
        for (; 0 <= offset; offset--) {
            ch = document.getChar(offset);
            if (ch != '\\') {
                break;
            }
            count++;
        }
        return (count % 2) == 0;
    }
    private int indentLen;
}
