/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;

public class EE2EIndentSnmp
implements EE2EIndentAction {
    private int snmpIndentLevel;

    public EE2EIndentSnmp(int snmpIndentLevel) {
        this.snmpIndentLevel = snmpIndentLevel;
    }

    public void doIndent(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int indent = this.doSnmpCalculateIndent(argumentOffset, document);
        EE2ELispBase.get().indentTo(argumentOffset, indent, document);
    }

    protected int doSnmpCalculateIndent(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int ansObject;
        int ans = 0;
        int nowOffset = argumentOffset;
        nowOffset = EE2ELispBase.get().beginningOfLine(nowOffset, document);
        if (nowOffset <= 0) {
            return 0;
        }
        nowOffset = EE2ELispBase.get().skipCharsForward(nowOffset, " \t\n\r", document);
        if (this.lookinAtFunctionObject(nowOffset + 1, document) && (ansObject = this.checkObject(nowOffset, document)) >= 0) {
            return ansObject;
        }
        nowOffset = EE2ELispBase.get().skipCharsBackward(nowOffset - 1, " \t\n\r", document);
        nowOffset = EE2ELispBase.get().beginningOfLine(nowOffset, document);
        if ((nowOffset = this.commentSkip(nowOffset, document)) < 0) {
            return 0;
        }
        ans = EE2ELispBase.get().indentLen(nowOffset, document);
        while (nowOffset < document.getLength()) {
            char ch = document.getChar(nowOffset);
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') break;
            ++nowOffset;
        }
        if (this.lookingAtSnmpMacroOpen(nowOffset, document)) {
            ans += this.snmpIndentLevel;
        } else if (this.lookingAtSnmpMacroClose(nowOffset, document)) {
            ans -= this.snmpIndentLevel;
        }
        return ans;
    }

    protected int checkObject(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int offset = argumentOffset;
        offset = EE2ELispBase.get().skipCharsBackward(offset, " \t\r\n", document);
        if (offset <= 0) {
            return -1;
        }
        while ((offset = EE2ELispBase.get().beginningOfLine(offset - 1, document)) > 0) {
            int nextOffset = EE2ELispBase.get().skipCharsForward(offset, " \t\r\n", document);
            if (!this.lookinAtFunctionObject(nextOffset + 1, document)) continue;
            int len = EE2ELispBase.get().indentLen(nextOffset + 1, document);
            return len;
        }
        return -1;
    }

    protected int commentSkip(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int offset = argumentOffset;
        while (true) {
            if ((offset = EE2ELispBase.get().beginningOfLine(offset, document)) <= 0) {
                return 0;
            }
            int nextOffset = EE2ELispBase.get().skipCharsForward(offset, " \t\r\n", document);
            if (document.getLength() <= nextOffset + 2) break;
            char ch1 = document.getChar(nextOffset + 1);
            char ch2 = document.getChar(nextOffset + 2);
            if (ch1 != '-' || ch2 != '-') break;
            --offset;
        }
        return offset;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean lookingAtSnmpMacroOpen(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        offset = argumentOffset;
        if (this.lookinAtFunctionObject(argumentOffset, document)) {
            return true;
        }
        if (EE2ELispBase.get().lookingAt(argumentOffset, "DESCRIPTION", document) || EE2ELispBase.get().lookingAt(argumentOffset, "IMPORTS", document) || EE2ELispBase.get().lookingAt(argumentOffset, "MODULE-IDENTITY", document) || EE2ELispBase.get().lookingAt(argumentOffset, "MODULE-COMPLIANCE", document)) {
            return true;
        }
        endOfLine = EE2ELispBase.get().endOfLine(offset, document);
        flag = false;
        offset = endOfLine - 3;
        while (argumentOffset <= offset) {
            ch1 = document.getChar(offset);
            ch2 = document.getChar(offset + 1);
            ch3 = document.getChar(offset + 2);
            if (ch1 == ':' && ch2 == ':' && ch3 == '=') {
                flag = true;
                break;
            }
            --offset;
        }
        if (!flag) {
            return false;
        }
        if (document.getLength() > (offset += 3)) ** GOTO lbl24
        return false;
        while ((ch = document.getChar(offset)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
            ++offset;
lbl24:
            // 2 sources

            if (offset < document.getLength()) continue;
        }
        if (document.getLength() <= offset) {
            return false;
        }
        target = "BEGIN";
        if (EE2ELispBase.get().lookingAt(offset, target, document)) {
            return this.isSpaceCheck(offset + target.length(), document) != false;
        }
        target = "TEXTUAL-CONVENTION";
        if (EE2ELispBase.get().lookingAt(offset, target, document)) {
            return this.isSpaceCheck(offset + target.length(), document) != false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean lookinAtFunctionObject(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        offset = argumentOffset;
        if (document.getLength() <= argumentOffset) {
            return false;
        }
        ch = document.getChar(offset);
        if (ch < 'a' || 'z' < ch) {
            return false;
        }
        if (document.getLength() > ++offset) ** GOTO lbl11
        return false;
        while ((ch = document.getChar(offset)) >= 'a' && 'z' >= ch || ch >= 'A' && 'Z' >= ch || ch >= '0' && '9' >= ch) {
            ++offset;
lbl11:
            // 2 sources

            if (offset < document.getLength()) continue;
        }
        if (document.getLength() <= offset) {
            return false;
        }
        ch = document.getChar(offset);
        if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') {
            return false;
        }
        if (document.getLength() > ++offset) ** GOTO lbl21
        return false;
        while ((ch = document.getChar(offset)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
            ++offset;
lbl21:
            // 2 sources

            if (offset < document.getLength()) continue;
        }
        if (document.getLength() <= offset) {
            return false;
        }
        return EE2ELispBase.get().lookingAt(offset, "OBJECT-TYPE", document) != false || EE2ELispBase.get().lookingAt(offset, "OBJECT-GROUP", document) != false || EE2ELispBase.get().lookingAt(offset, "TRAP-TYPE", document) != false || EE2ELispBase.get().lookingAt(offset, "TRAP-GROUP", document) != false;
    }

    protected boolean lookingAtSnmpMacroClose(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        char ch;
        int endOfLine;
        int offset = argumentOffset;
        String target = "END";
        if (EE2ELispBase.get().lookingAt(offset, target, document)) {
            return this.isSpaceCheck(offset + target.length(), document);
        }
        int skipOffset = endOfLine = EE2ELispBase.get().endOfLine(offset, document);
        while (offset <= skipOffset) {
            ch = document.getChar(skipOffset);
            if (ch == ';') {
                return this.isSpaceCheck(skipOffset + 1, document);
            }
            --skipOffset;
        }
        target = "::=";
        if (!EE2ELispBase.get().lookingAt(offset, target, document)) {
            return false;
        }
        offset += target.length();
        while (offset < document.getLength()) {
            ch = document.getChar(offset);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') break;
            ++offset;
        }
        ch = document.getChar(offset);
        return ch == '{';
    }

    protected boolean isSpaceCheck(int argumentOffset, EE2EDocument document) throws EE2EIndentException {
        int endOfLine = EE2ELispBase.get().endOfLine(argumentOffset, document);
        int offset = argumentOffset;
        while (offset <= endOfLine) {
            char ch = document.getChar(offset);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') {
                return false;
            }
            ++offset;
        }
        return true;
    }
}

