package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentListener;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates. To enable and disable the
 * creation of type comments go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation.
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EEclipseDocument implements EE2EDocument {
    public EE2EEclipseDocument(IDocument document) {
        this.document = document;
    }

    public EE2EEclipseDocument(String string) {
        this.document = new Document(string);
    }

    /**
     * Returns the number of characters in this document.
     * 
     * @return the number of characters in this document
     */
    public int getLength() {
        return this.document.getLength();
    }

    /**
     * Returns the character at the given document offset in this document.
     * 
     * @param offset
     *            a document offset
     * @return the character at the offset
     * @exception BadLocationException
     *                if the offset is invalid in this document
     */
    public char getChar(int offset) throws EE2EIndentException {
        try {
            return this.document.getChar(offset);
        } catch (BadLocationException e) {
            throw new EE2EIndentException(e.getMessage());
        }
    }

    /**
     * Returns this document's complete text.
     * 
     * @return the document's complete text
     */
    public String get() {
        return this.document.get();
    }

    /**
     * Returns the number of lines in this document
     *
     * @return the number of lines in this document
     */
    public int getNumberOfLines() {
        return this.document.getNumberOfLines();
    }

    /**
     * Determines the offset of the first character of the given line.
     *
     * @param line the line of interest
     * @return the document offset
     * @exception BadLocationException if the line number is invalid in this document
     */
    public int getLineOffset(int line) throws EE2EIndentException {
        try {
            return this.document.getLineOffset(line);
        } catch (BadLocationException e) {
            throw new EE2EIndentException(e.getMessage());
        }
    }

    /**
     * Returns this document's text for the specified range.
     * 
     * @param offset
     *            the document offset
     * @param length
     *            the length of the specified range
     * @return the document's text for the specified range
     * @exception BadLocationException
     *                if the range is invalid in this document
     */
    public String get(int offset, int length) throws EE2EIndentException {
        try {
            return this.document.get(offset, length);
        } catch (BadLocationException e) {
            throw new EE2EIndentException(e.getMessage());
        }
    }

    /**
     * Replaces the content of the document with the given text. Sends a
     * <code>DocumentEvent</code> to all registered
     * <code>IDocumentListener</code>. This method is a convenience method
     * for <code>replace(0, getLength(), text)</code>.
     * 
     * @param text
     *            the new content of the document
     */
    public void set(String text) {
        this.document.set(text);
    }

    /**
     * Substitutes the given text for the specified document range. Sends a
     * <code>DocumentEvent</code> to all registered
     * <code>IDocumentListener</code>.
     * 
     * @param offset
     *            the document offset
     * @param length
     *            the length of the specified range
     * @param text
     *            the substitution text
     * @exception BadLocationException
     *                if the offset is invalid in this document
     * 
     * @see DocumentEvent
     * @see IDocumentListener
     */
    public void replace(int offset, int length, String text)
            throws EE2EIndentException {
        try {
            this.document.replace(offset, length, text);
        } catch (BadLocationException e) {
            throw new EE2EIndentException(e.getMessage());
        }
    }

    private IDocument document;
}