/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EEclipseDocument;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2ESelectIndent;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EIndentBehavior
implements EE2EMenuBehavior {
    private EE2EIndentAction action;

    public EE2EIndentBehavior(EE2EIndentAction action) {
        this.action = action;
    }

    public String getText() {
        return EE2EPlugin.getResourceString("action.indent");
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.indent.tooltip");
    }

    public final void doBehavior(AbstractTextEditor editor, ITextSelection textSelection) throws BadLocationException {
        try {
            IDocument iDocument = EE2EToolkit.get().getEditorToDocument(editor);
            EE2EEclipseDocument document = new EE2EEclipseDocument(iDocument);
            int offset = textSelection.getOffset() + textSelection.getLength();
            Position saveExcursion = new Position(offset);
            iDocument.addPosition(saveExcursion);
            this.action.doIndent(offset, document);
            offset = saveExcursion.getOffset();
            iDocument.removePosition(saveExcursion);
            int head = EE2ELispBase.get().beginningOfLine(offset, document);
            head = EE2ELispBase.get().skipCharsForward(head, " \t", document) + 1;
            if (head < document.getLength()) {
                offset = head;
            }
            EE2ESelectIndent sec = new EE2ESelectIndent(offset);
            editor.getSelectionProvider().setSelection((ISelection)sec);
            editor.setFocus();
        }
        catch (EE2EIndentException e) {
            throw new BadLocationException(e.getMessage());
        }
    }

    public EE2EIndentAction getAction() {
        return this.action;
    }
}

