/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentAction;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentJava;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentXML;
import jp.sourceforge.projects.ee2e.core.indent.EE2ELispBase;

public class EE2EIndentJsp
implements EE2EIndentAction {
    private EE2EIndentJava javaIndent;
    private EE2EIndentXML xmlIndent;

    public EE2EIndentJsp(EE2EIndentXML xml, boolean isRedundantCircleFlag) {
        this.javaIndent = new EE2EIndentJava(4, isRedundantCircleFlag);
        this.xmlIndent = xml;
    }

    public void doIndent(int offset, EE2EDocument document) throws EE2EIndentException {
        int nextOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        boolean isJavaIndent = false;
        while (nextOffset > 0) {
            char nextCh;
            nextOffset = EE2ELispBase.get().findCharsBackward(nextOffset, "<>", document);
            if (nextOffset <= 0) break;
            char ch = document.getChar(nextOffset);
            if ('<' == ch) {
                nextCh = document.getChar(nextOffset + 1);
                if ('?' == nextCh || '%' == nextCh) {
                    isJavaIndent = true;
                    break;
                }
            } else if ('>' == ch) {
                nextCh = document.getChar(nextOffset - 1);
                if ('?' == nextCh || '%' == nextCh) {
                    isJavaIndent = false;
                    break;
                }
            } else {
                isJavaIndent = false;
            }
            --nextOffset;
        }
        if (isJavaIndent) {
            this.javaIndent.doIndent(offset, document);
        } else {
            this.xmlIndent.doIndent(offset, document);
        }
    }
}

