/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.relax.EE2REnumeration;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import jp.sourceforge.projects.ee2e.core.relax.RStack;
import jp.sourceforge.projects.ee2e.core.relax.UJAXP;
import jp.sourceforge.projects.ee2e.core.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RAttribute
implements Serializable,
IEE2RDefvarChoice {
    private String name_;
    private String ref_;
    private List enumeration_ = new ArrayList();

    public EE2RAttribute() {
    }

    public EE2RAttribute(RStack stack) {
        this.setup(stack);
    }

    public EE2RAttribute(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RAttribute(Element element) {
        this.setup(element);
    }

    public EE2RAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.ref_ = URelaxer.getAttributePropertyAsString(element, "ref");
        this.enumeration_.clear();
        while (!stack.isEmptyElement()) {
            if (!EE2REnumeration.isMatch(stack)) break;
            this.addEnumeration(new EE2REnumeration(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("attribute");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.ref_ != null) {
            URelaxer.setAttributePropertyByString(element, "ref", this.ref_);
        }
        int size = this.enumeration_.size();
        int i = 0;
        while (i < size) {
            EE2REnumeration value = (EE2REnumeration)this.enumeration_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getRef() {
        return this.ref_;
    }

    public final void setRef(String ref) {
        this.ref_ = ref;
    }

    public final EE2REnumeration[] getEnumeration() {
        EE2REnumeration[] array = new EE2REnumeration[this.enumeration_.size()];
        return this.enumeration_.toArray(array);
    }

    public final void setEnumeration(EE2REnumeration[] enumeration) {
        this.enumeration_.clear();
        this.enumeration_.addAll((Collection)Arrays.asList(enumeration));
    }

    public final void setEnumeration(EE2REnumeration enumeration) {
        this.enumeration_.clear();
        this.enumeration_.add(enumeration);
    }

    public final void addEnumeration(EE2REnumeration enumeration) {
        this.enumeration_.add(enumeration);
    }

    public final int getEnumerationCount() {
        return this.enumeration_.size();
    }

    public final EE2REnumeration getEnumeration(int index) {
        return (EE2REnumeration)this.enumeration_.get(index);
    }

    public final void setEnumeration(int index, EE2REnumeration enumeration) {
        this.enumeration_.set(index, enumeration);
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<attribute");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getName()));
            buffer.append("\"");
        }
        if (this.ref_ != null) {
            buffer.append(" ref=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getRef()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.enumeration_.size();
        int i = 0;
        while (i < size) {
            EE2REnumeration value = (EE2REnumeration)this.enumeration_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</attribute>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<attribute");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getName()));
            buffer.print("\"");
        }
        if (this.ref_ != null) {
            buffer.print(" ref=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getRef()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.enumeration_.size();
        int i = 0;
        while (i < size) {
            EE2REnumeration value = (EE2REnumeration)this.enumeration_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</attribute>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "attribute")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2REnumeration.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RAttribute.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RAttribute.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

