/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.relax.EE2RProcess;
import jp.sourceforge.projects.ee2e.core.relax.RStack;
import jp.sourceforge.projects.ee2e.core.relax.UJAXP;
import jp.sourceforge.projects.ee2e.core.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RProcessList
implements Serializable {
    private String processName_;
    private String folder_;
    private String file_;
    private String fileType_;
    private Boolean isUnix_;
    private Boolean isJava_;
    private List process_ = new ArrayList();

    public EE2RProcessList() {
    }

    public EE2RProcessList(RStack stack) {
        this.setup(stack);
    }

    public EE2RProcessList(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RProcessList(Element element) {
        this.setup(element);
    }

    public EE2RProcessList(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RProcessList(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RProcessList(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RProcessList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RProcessList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RProcessList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.processName_ = URelaxer.getAttributePropertyAsString(element, "processName");
        this.folder_ = URelaxer.getAttributePropertyAsString(element, "folder");
        this.file_ = URelaxer.getAttributePropertyAsString(element, "file");
        this.fileType_ = URelaxer.getAttributePropertyAsString(element, "fileType");
        this.isUnix_ = URelaxer.getAttributePropertyAsBooleanObject(element, "isUnix");
        this.isJava_ = URelaxer.getAttributePropertyAsBooleanObject(element, "isJava");
        this.process_.clear();
        while (!stack.isEmptyElement()) {
            if (!EE2RProcess.isMatch(stack)) break;
            this.addProcess(new EE2RProcess(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("processList");
        if (this.processName_ != null) {
            URelaxer.setAttributePropertyByString(element, "processName", this.processName_);
        }
        if (this.folder_ != null) {
            URelaxer.setAttributePropertyByString(element, "folder", this.folder_);
        }
        if (this.file_ != null) {
            URelaxer.setAttributePropertyByString(element, "file", this.file_);
        }
        if (this.fileType_ != null) {
            URelaxer.setAttributePropertyByString(element, "fileType", this.fileType_);
        }
        if (this.isUnix_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "isUnix", this.isUnix_);
        }
        if (this.isJava_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "isJava", this.isJava_);
        }
        int size = this.process_.size();
        int i = 0;
        while (i < size) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getProcessName() {
        return this.processName_;
    }

    public final void setProcessName(String processName) {
        this.processName_ = processName;
    }

    public final String getFolder() {
        return this.folder_;
    }

    public final void setFolder(String folder) {
        this.folder_ = folder;
    }

    public final String getFile() {
        return this.file_;
    }

    public final void setFile(String file) {
        this.file_ = file;
    }

    public final String getFileType() {
        return this.fileType_;
    }

    public final void setFileType(String fileType) {
        this.fileType_ = fileType;
    }

    public boolean getIsUnix() throws IllegalStateException {
        if (this.isUnix_ == null) {
            throw new IllegalStateException("isUnix_");
        }
        return this.isUnix_;
    }

    public Boolean getIsUnixAsBoolean() throws IllegalStateException {
        return this.isUnix_;
    }

    public boolean checkIsUnix() {
        return this.isUnix_ != null;
    }

    public void setIsUnix(boolean isUnix) {
        this.isUnix_ = new Boolean(isUnix);
    }

    public void setIsUnix(Boolean isUnix) {
        this.isUnix_ = isUnix;
    }

    public boolean getIsJava() throws IllegalStateException {
        if (this.isJava_ == null) {
            throw new IllegalStateException("isJava_");
        }
        return this.isJava_;
    }

    public Boolean getIsJavaAsBoolean() throws IllegalStateException {
        return this.isJava_;
    }

    public boolean checkIsJava() {
        return this.isJava_ != null;
    }

    public void setIsJava(boolean isJava) {
        this.isJava_ = new Boolean(isJava);
    }

    public void setIsJava(Boolean isJava) {
        this.isJava_ = isJava;
    }

    public final EE2RProcess[] getProcess() {
        EE2RProcess[] array = new EE2RProcess[this.process_.size()];
        return this.process_.toArray(array);
    }

    public final void setProcess(EE2RProcess[] process) {
        this.process_.clear();
        this.process_.addAll((Collection)Arrays.asList(process));
    }

    public final void setProcess(EE2RProcess process) {
        this.process_.clear();
        this.process_.add(process);
    }

    public final void addProcess(EE2RProcess process) {
        this.process_.add(process);
    }

    public final int getProcessCount() {
        return this.process_.size();
    }

    public final EE2RProcess getProcess(int index) {
        return (EE2RProcess)this.process_.get(index);
    }

    public final void setProcess(int index, EE2RProcess process) {
        this.process_.set(index, process);
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<processList");
        if (this.processName_ != null) {
            buffer.append(" processName=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getProcessName()));
            buffer.append("\"");
        }
        if (this.folder_ != null) {
            buffer.append(" folder=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getFolder()));
            buffer.append("\"");
        }
        if (this.file_ != null) {
            buffer.append(" file=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getFile()));
            buffer.append("\"");
        }
        if (this.fileType_ != null) {
            buffer.append(" fileType=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getFileType()));
            buffer.append("\"");
        }
        if (this.isUnix_ != null) {
            buffer.append(" isUnix=\"");
            buffer.append(new Boolean(this.getIsUnix()).toString());
            buffer.append("\"");
        }
        if (this.isJava_ != null) {
            buffer.append(" isJava=\"");
            buffer.append(new Boolean(this.getIsJava()).toString());
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.process_.size();
        int i = 0;
        while (i < size) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</processList>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<processList");
        if (this.processName_ != null) {
            buffer.print(" processName=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getProcessName()));
            buffer.print("\"");
        }
        if (this.folder_ != null) {
            buffer.print(" folder=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getFolder()));
            buffer.print("\"");
        }
        if (this.file_ != null) {
            buffer.print(" file=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getFile()));
            buffer.print("\"");
        }
        if (this.fileType_ != null) {
            buffer.print(" fileType=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getFileType()));
            buffer.print("\"");
        }
        if (this.isUnix_ != null) {
            buffer.print(" isUnix=\"");
            buffer.print(new Boolean(this.getIsUnix()).toString());
            buffer.print("\"");
        }
        if (this.isJava_ != null) {
            buffer.print(" isJava=\"");
            buffer.print(new Boolean(this.getIsJava()).toString());
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.process_.size();
        int i = 0;
        while (i < size) {
            EE2RProcess value = (EE2RProcess)this.process_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</processList>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "processList")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RProcess.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RProcessList.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RProcessList.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

