package jp.sourceforge.projects.ee2e.core.cdt;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.*;
import jp.sourceforge.projects.ee2e.core.indent.EE2ECppMiniFormatBehavior;

import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECppMiniFormat implements EE2EMenuBehavior {
    public EE2ECppMiniFormat() {
        /*EMPTY*/
    }

    /**
    * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
    */
    public String getText() {
        return EE2EPlugin.getResourceString("action.c.miniformat") + "(&>)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.c.miniformat.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
    public void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        EE2ECppMiniFormatBehavior behavior = new EE2ECppMiniFormatBehavior();
        try {
            document.set(behavior.doBehavior(document.get()));
        } catch (java.io.IOException e) {
            EE2EDebug.printf(10, "IOException e=" + e.getMessage());
        }
    }
}
