package jp.sourceforge.projects.ee2e.core.cdt;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.*;
import jp.sourceforge.projects.ee2e.core.indent.EE2ECppSharp;

import org.eclipse.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ESharpFormat implements EE2EMenuBehavior {
    public EE2ESharpFormat() {
        /*EMPTY*/
    }

    /**
    * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
    */
    public String getText() {
        return EE2EPlugin.getResourceString("action.c.sharp") + "(&<)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.c.sharp.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
    public void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        try {
            Shell parent =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (parent == null) {
                EE2EDebug.printf(1, "page not found");
                return;
            }
            //
            java.io.StringReader sReader =
                new java.io.StringReader(document.get());
            java.io.BufferedReader bReader =
                new java.io.BufferedReader(sReader);
            //
            EE2ECppSharp sharp = new EE2ECppSharp("");
            sharp.createComposit(bReader);
            bReader.close();
            java.util.Collection collection = new java.util.TreeSet();
            sharp.getDefines(collection);
            //
            EE2ESharpDialog dialog = new EE2ESharpDialog(parent);
            dialog.open(collection);
            //
            if (dialog.getTarget() != null) {
                java.io.StringWriter sWriter = new java.io.StringWriter();
                EE2EDebug.printf(
                    5,
                    "target="
                        + dialog.getTarget()
                        + " flag="
                        + dialog.getIsIfOrElse());
                sharp.destoryTarget(dialog.getTarget(), dialog.getIsIfOrElse());
                sharp.getWriter(sWriter, false);
                sWriter.close();
                document.set(sWriter.toString());
            }
        } catch (java.io.IOException e) {
            EE2EDebug.printf(10, "IOException e=" + e.getMessage());
        }
    }
}
