package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.jface.action.IMenuManager;
import jp.sourceforge.projects.ee2e.core.*;
import jp.sourceforge.projects.ee2e.core.cf.*;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates. To enable and disable the
 * creation of type comments go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation.
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECreateIMenuManager {
    public EE2ECreateIMenuManager() {
        EE2EDebug.printf(5, "EE2ECreateIMenuManager#EE2ECreateIMenuManager");
        java.net.URL baseURL =
            EE2EPlugin.getDefault().getBundle().getEntry("/");
        tabDestroyAction = new EE2EAction();
        try {
            java.net.URL prefix =
                new java.net.URL(baseURL, "icons/ee2eerase.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL(prefix);
            tabDestroyAction.setImageDescriptor(image);
        } catch (java.net.MalformedURLException e) {
            /* EMPTY */
        }
        //
        tabIndentAction = new EE2EAction();
        tabIndentAction.setAccelerator(Action.findKeyCode("TAB"));
        tabIndentAction.setId(EE2EPlugin.INDENT_ID);
        tabIndentAction.setActionDefinitionId(EE2EPlugin.INDENT_ID);
        tabIndentAction.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        //
        tabFormatAction = new EE2EAction();
        //
        structureBegin = new EE2EAction();
        structureBegin.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        structureSection = new EE2EAction();
        structureSection.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        structureLarge = new EE2EAction();
        structureLarge.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        structureBig = new EE2EAction();
        structureBig.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        structureReturn = new EE2EAction();
        structureReturn.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        insertIterator = new EE2EAction();
        insertIterator.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OPEN_MARKER));
        fileJumpRegion = new EE2EAction();
        try {
            java.net.URL prefix = new java.net.URL(baseURL, "icons/ee2e.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL(prefix);
            fileJumpRegion.setImageDescriptor(image);
        } catch (java.net.MalformedURLException e) {
            /* EMPTY */
        }
        preview = new EE2EAction();
        try {
            java.net.URL prefix =
                new java.net.URL(baseURL, "icons/ee2esystem.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL(prefix);
            preview.setImageDescriptor(image);
        } catch (java.net.MalformedURLException e) {
            /* EMPTY */
        }
        derivationResource = new EE2EAction();
        derivationResourceSystem = new EE2EAction();
        translateRegion = new EE2EAction();
        translateRegion.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        translateBigRegion = new EE2EAction();
        translateBigRegion.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        unTranslateRegion = new EE2EAction();
        unTranslateRegion.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        commentRegion = new EE2EAction();
        commentRegion.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        unCommentRegion = new EE2EAction();
        unCommentRegion.setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                IDE.SharedImages.IMG_OBJS_TASK_TSK));
        recenter = new EE2EAction();
        completeMarkRight = new EE2EAction();
        completeMarkLeft = new EE2EAction();
        completeMarkAmp = new EE2EAction();
        completeMarkQuot = new EE2EAction();
        completeMarkApos = new EE2EAction();
        completeMarkNbsp = new EE2EAction();
        copyScratch = new EE2EAction();
    }

    public void overWriteManager(IMenuManager manager) {
        EE2EDebug.printf(5, "EE2ECreateIMenuManager#overWriteManager");
        if (manager == null) {
            return;
        }
        IMenuManager menu = new MenuManager("EE2E(&c)");
        manager.prependToGroup(IWorkbenchActionConstants.MB_ADDITIONS, menu);
        menu.add(tabDestroyAction);
        menu.add(tabIndentAction);
        menu.add(tabFormatAction);
        menu.add(structureBegin);
        menu.add(structureSection);
        menu.add(structureLarge);
        menu.add(structureBig);
        menu.add(structureReturn);
        menu.add(insertIterator);
        menu.add(fileJumpRegion);
        //
        IMenuManager typesetmanager =
            new MenuManager(
                EE2EPlugin.getResourceString("action.typeset") + "(&t)");
        typesetmanager.add(preview);
        typesetmanager.add(derivationResource);
        typesetmanager.add(derivationResourceSystem);
        menu.add(typesetmanager);
        //
        menu.add(translateRegion);
        menu.add(translateBigRegion);
        menu.add(unTranslateRegion);
        menu.add(commentRegion);
        menu.add(unCommentRegion);
        menu.add(recenter);
        IMenuManager mark =
            new MenuManager(
                EE2EPlugin.getResourceString("action.complete") + "(&a)");
        menu.add(mark);
        mark.add(completeMarkRight);
        mark.add(completeMarkLeft);
        mark.add(completeMarkAmp);
        mark.add(completeMarkQuot);
        mark.add(completeMarkApos);
        mark.add(completeMarkNbsp);
        //
        IMenuManager windows =
            new MenuManager(
                EE2EPlugin.getResourceString("action.windows") + "(&w)");
        menu.add(windows);
        for (int i = 1; i < 10; i++) {
            windows.add(new EE2EWindows(i));
        }
        menu.add(copyScratch);
        menu.add(new EE2EReload());
    }

    protected void setActivePart(AbstractTextEditor part) {
        EE2EDebug.printf(5, "EE2ECreateIMenuManager:setActivePart");
        String fileName = part.getEditorInput().getName();
        EE2ECF factory = EE2EGetFactory.get().getFactory(fileName);
        //
        tabDestroyAction.setEE2EMenuBehavior(part, factory.tabDestroyAction());
        //
        tabIndentAction.setId(EE2EPlugin.INDENT_ID);
        tabIndentAction.setActionDefinitionId(EE2EPlugin.INDENT_ID);
        tabIndentAction.setEE2EMenuBehavior(part, factory.indentAction());
        part.setAction(EE2EPlugin.INDENT_ID, tabIndentAction);
        //
        tabFormatAction.setEE2EMenuBehavior(part, factory.tabFormatAction());
        structureBegin.setEE2EMenuBehavior(part, factory.structureBegin());
        structureSection.setEE2EMenuBehavior(part, factory.structureSection());
        structureLarge.setEE2EMenuBehavior(part, factory.structureLearge());
        structureBig.setEE2EMenuBehavior(part, factory.structureBig());
        structureReturn.setEE2EMenuBehavior(part, factory.structureReturn());
        insertIterator.setEE2EMenuBehavior(part, factory.insertIterator());
        fileJumpRegion.setEE2EMenuBehavior(part, factory.fileJumpRegion());
        derivationResource.setEE2EMenuBehavior(
            part,
            factory.derivationResource());
        derivationResourceSystem.setEE2EMenuBehavior(
            part,
            factory.derivationResourceSystem());
        preview.setEE2EMenuBehavior(part, factory.preview());
        translateRegion.setEE2EMenuBehavior(part, factory.translateRegion());
        translateBigRegion.setEE2EMenuBehavior(
            part,
            factory.translateBigRegion());
        unTranslateRegion.setEE2EMenuBehavior(
            part,
            factory.unTranslateRegion());
        commentRegion.setEE2EMenuBehavior(part, factory.commentRegion());
        unCommentRegion.setEE2EMenuBehavior(part, factory.unCommentRegion());
        recenter.setEE2EMenuBehavior(part, new EE2ERecenter());
        completeMarkRight.setEE2EMenuBehavior(
            part,
            factory.completeMarkRight());
        completeMarkLeft.setEE2EMenuBehavior(part, factory.completeMarkLeft());
        completeMarkAmp.setEE2EMenuBehavior(part, factory.completeMarkAmp());
        completeMarkQuot.setEE2EMenuBehavior(part, factory.completeMarkQuot());
        completeMarkApos.setEE2EMenuBehavior(part, factory.completeMarkApos());
        completeMarkNbsp.setEE2EMenuBehavior(part, factory.completeMarkNbsp());
        copyScratch.setEE2EMenuBehavior(part, new EE2ECopyScratch());
    }
    private EE2EAction tabDestroyAction;
    private EE2EAction tabIndentAction;
    private EE2EAction tabFormatAction;
    private EE2EAction translateRegion;
    private EE2EAction translateBigRegion;
    private EE2EAction unTranslateRegion;
    private EE2EAction structureBegin;
    private EE2EAction structureSection;
    private EE2EAction structureLarge;
    private EE2EAction structureBig;
    private EE2EAction structureReturn;
    private EE2EAction fileJumpRegion;
    private EE2EAction preview;
    private EE2EAction derivationResource;
    private EE2EAction derivationResourceSystem;
    private EE2EAction insertIterator;
    private EE2EAction commentRegion;
    private EE2EAction unCommentRegion;
    private EE2EAction recenter;
    private EE2EAction completeMarkRight;
    private EE2EAction completeMarkLeft;
    private EE2EAction completeMarkAmp;
    private EE2EAction completeMarkQuot;
    private EE2EAction completeMarkApos;
    private EE2EAction completeMarkNbsp;
    private EE2EAction copyScratch;
}
