package jp.sourceforge.projects.ee2e.core.indent;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public interface EE2EDocument {
    /**
     * Returns the number of characters in this document.
     *
     * @return the number of characters in this document
     */
    int getLength();

    /**
     * Returns the character at the given document offset in this document.
     *
     * @param offset a document offset
     * @return the character at the offset
     * @exception EE2EIndentException if the offset is invalid in this document
     */
    char getChar(int offset) throws EE2EIndentException;

    /**
     * Returns this document's complete text.
     *
     * @return the document's complete text
     */
    String get();
    
    /**
     * Returns this document's text for the specified range.
     *
     * @param offset the document offset
     * @param length the length of the specified range
     * @return the document's text for the specified range
     * @exception EE2EIndentException if the range is invalid in this document
     */
    String get(int offset, int length) throws EE2EIndentException;

    /**
     * Returns the number of lines in this document
     *
     * @return the number of lines in this document
     */
    int getNumberOfLines();

    /**
     * Determines the offset of the first character of the given line.
     *
     * @param line the line of interest
     * @return the document offset
     * @exception BadLocationException if the line number is invalid in this document
     */
    int getLineOffset(int line) throws EE2EIndentException;

    /**
     * Replaces the content of the document with the given text.
     * Sends a <code>DocumentEvent</code> to all registered <code>IDocumentListener</code>.
     * This method is a convenience method for <code>replace(0, getLength(), text)</code>.
     *
     * @param text the new content of the document
     */
    void set(String text);

    /**
     * Substitutes the given text for the specified document range.
     * Sends a <code>DocumentEvent</code> to all registered <code>IDocumentListener</code>.
     *
     * @param offset the document offset
     * @param length the length of the specified range
     * @param text the substitution text
     * @exception EE2EIndentException if the offset is invalid in this document
     *
     * @see DocumentEvent
     * @see IDocumentListener
     */
    void replace(int offset, int length, String text) throws EE2EIndentException;
}
